<?php
/**
* @version		$Id: plgUserSpamCheck.php
* @package		User SpamCheck - check for possible spambots during register and login
* @author		vi-solutions, Robert Kuster
* @copyright	Copyright (C) 2010 vi-solutions. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
jimport('joomla.plugin.plugin');
require_once(JPATH_SITE.DS.'plugins'.DS.'user'.DS.'spambotcheck'.DS.'SpambotCheck'.DS.'SpambotCheckImpl.php');
require_once(JPATH_SITE.DS.'plugins'.DS.'user'.DS.'spambotcheck'.DS.'SpambotCheck'.DS.'SpambotCheckHelpers.php');


class plgUserSpambotCheck extends JPlugin
{
	public function plgUserSpambotCheck(& $subject, $config) {
		parent::__construct($subject, $config);
		
		//load the translation
		$this->loadLanguage();
		//XDebug
		/*$message = $this->_isSpammer();
		$app = JFactory::getApplication();
		$app->redirect('index.php', $message);
		$app->close();*/
	}
	
	//joomla 1.6 compatibility code 
 	public function onUserLogin($user, $options){
 	    $result = $this->onLoginUser($user, $options);
 	    return $result;
 	}
	
	public function onUserBeforeSave($user, $isnew, $new){
 	    $result = $this->onBeforeStoreUser($user, $isnew, $new);
 	    return $result;	
	}
	
	

	
	
	/**
	 * Example store user method
	 *
	 * Method is called before user data is stored in the database
	 *
	 * @param 	array		holds the old user data (without new changes applied)
	 * @param 	boolean		true if a new user is stored
	 * 
	 * RKFIX - Check if this is a known spammer. If so:
	 * 			> prevent user registration
	 *			> notify the admins about the registration attempt via email
	 *			> show the the normal login notification to the user 
	 */
	function onBeforeStoreUser($userOld, $isnew)
	{	
		if (JFactory::getApplication()->isSite()) {
			//AVack 20110811 :: For 1.6: Userdata are stored in array jform
			$data = JRequest::getVar('jform');	
			$user = array( 
				"fullname" => $data['name'],
				"username" => $data['username'],
				"email" => $data['email1']
			 );
			
			$this->params->set('current_action', 'Register');
			$spamString = "";
			if($isnew && plgUserSpambotCheck::_isSpammer($user, $spamString))
			{

				
				//check if users have lately registered with this IP
				if ($this->params->get('isSpamIp', 0) == 1)
				{
					$componentInstalled = plgSpambotCheckHelpers::checkComponentInstalled();
					if ($componentInstalled)
					{
						plgSpambotCheckHelpers::flagUserWithSpamUserIp();
					}
				}
				
				//------------------------------------------------
				// send email notification to all sys-admins
				plgUserSpambotCheck::_sendMailToAdmin($user, $spamString, JText::_( 'PLG_USER_SPAMBOTCHECK_EMAIL_SUBJECT_REGISTER_PREVENTION_TXT' ));
				// redirect us to the old page and display an error notificaton to the user	
				$usersConfig = JComponentHelper::getParams( 'com_users' );
				$message  = JText::_( 'PLG_USER_SPAMBOTCHECK_USER_REGISTRATION_SPAM_TXT' );
				$app = JFactory::getApplication();
				$app->redirect('index.php', $message, "error");
				$app->close();
				return false;	
			}
		}
		return true;
	}
	
	function onUserAfterSave($data, $isNew, $result, $error)
	{

		$userId = JArrayHelper::getValue($data, 'id', 0, 'int');
		//only for new users that were saved successfully in database
		if ($userId && $isNew && $result)
		{
			$componentInstalled = plgSpambotCheckHelpers::checkComponentInstalled();
			if ($componentInstalled)
			{
				//insert the new user into users_spambot table
				if (!plgSpambotCheckHelpers::logUserData($userId)) 
				{
					//No message
					return false;
				}
				if (JFactory::getApplication()->isSite()) 
				{
					//check if a user has allready registered using the same IP
					plgSpambotCheckHelpers::checkIpSuspicious($data, $this->params);
					//check for suspicious email addresses
					plgSpambotCheckHelpers::checkEmailSuspicious($data);
				}
			}
		}

		return true;
	}
	
	function onUserAfterDelete( $user, $success, $msg)
	{
		$userId = JArrayHelper::getValue($user, 'id', 0, 'int');
		if ($userId &&  $success)
		{
			$componentInstalled = plgSpambotCheckHelpers::checkComponentInstalled();
			if ($componentInstalled)
			{
				// get Ip of deleted user
				$userIp = plgSpambotCheckHelpers::getTableFieldValue('#__user_spambotcheck', 'ip', 'user_id', $userId);
				//Delete row in table user_spambotcheck
				$db = JFactory::getDbo();
				$query = $db->getQuery(true);
				$conditions = array(
					$db->quoteName('user_id') . ' = ' . $db->quote($userId)
				);
				 
				$query->delete($db->quoteName('#__user_spambotcheck'));
				$query->where($conditions);
				 
				$db->setQuery($query);
				$result = $db->query();
				
				//clean up user_spambotcheck fields
				plgSpambotCheckHelpers::cleanUserSpambotTable($userIp, $userId);
			}
		}
		return true;
	}
	
	
	/**
	 * This method should handle any login logic and report back to the subject
	 *
	 * @access	public
	 * @param   array   holds the user data
	 * @param 	array   array holding options (remember, autoregister, group)
	 * @return	boolean	True on success
	 * @since	1.5
	 * 
	 * RKFIX - Check if this is a known spammer. If so:
	 * 			> prevent a login
	 *			> notify the admins about the login attempt via email 
	 *			> show an error message to the user
	 */
	function onLoginUser($user, $options = array())
	{
		if (!$this->params->get('spbot_monitor_events', 1))	{
			// -> dont monitor log-ins 
			return true;
		}
		
		//Is user trusted and not to check?
		$userId = plgSpambotCheckHelpers::getTableFieldValue('#__users', 'id', 'email', $user['email']); 
		$componentInstalled = plgSpambotCheckHelpers::checkComponentInstalled();
		if ($componentInstalled && plgSpambotCheckHelpers::getTableFieldValue('#__user_spambotcheck', 'trust', 'user_id', $userId) == 1)
		{
			return true;
		}
		
		$this->params->set('current_action', 'Login');
		$spamString = "";
		if (plgUserSpambotCheck::_isSpammer($user, $spamString))
		{
			if (($spamString != "") && (strpos($spamString, 'E-Mail in Backlist') === false))
			{
				//set user to suspicious if not allready done
				//get Value of note field
				if ($componentInstalled) 
				{
					$notevalue = plgSpambotCheckHelpers::getTableFieldValue('#__user_spambotcheck', 'note', 'user_id', $userId);
					if (strpos($notevalue,'4: User flagged; ') === false)
					{
						$note = '4: User flagged; ';
						// Create an object for the record we are going to update.
						$object = new stdClass();
						$object->user_id = $userId;
						
						//Add a note
						$object->note = $notevalue . $note;
						//Set suspicious state
						
						$object->suspicious = 0;
				
						// Update their details in the users table using user_id as the primary key.
						$result = JFactory::getDbo()->updateObject('#__user_spambotcheck', $object, 'user_id');
					}
					
					//check if users have lately registered with this IP
					if ($this->params->get('isSpamIp', 0) == 1)
					{
						plgSpambotCheckHelpers::flagUserWithSpamUserIp($userId);
					}
				}
			}
			
			//------------------------------------------------
			// Undo task done in plgUserJoomla::onLoginUser
			// (in essence we are forcing a logout operation done by plgUserJoomla here)
			
			//xdebug
			$config	= JComponentHelper::getParams('com_users');
			$defaultUserGroup = $config->get('new_usertype', 2);
			
			// -> store a guest-JUser to the session		 
			$instance = new JUser();	// createsa guest user	
			$instance->set( 'id'			, 0 );
			$instance->set( 'name'			, '' );
			$instance->set( 'username'		, '' );
			$instance->set('usertype'		, 'deprecated');
			$instance->set('groups'		, array($defaultUserGroup));
					
			$session =& JFactory::getSession();
			$session->set('user', $instance);	

			// -> store a guest-JUser to the #__session table
			$table = & JTable::getInstance('session');	// Get the session-table object
			$table->load( $session->getId() );	

			$table->guest 		= $instance->get('guest');
			$table->username 	= $instance->get('username');
			$table->userid 		= intval($instance->get('id'));
			$table->usertype 	= $instance->get('usertype');
			$table->set('groups');
			
			$table->update();
			//------------------------------------------------
			// send email notification to all sys-admins
			if (($spamString != "") && (strpos($spamString, 'E-Mail in Backlist') === false))
			{
				plgUserSpambotCheck::_sendMailToAdmin($user, $spamString, JText::_( 'PLG_USER_SPAMBOTCHECK_EMAIL_SUBJECT_LOGIN_PREVENTION_TXT' ));
			}
			
			//------------------------------------------------
			// redirect us to the old page and display an error notificaton to the user
			$app = JFactory::getApplication();
			$app->redirect(JRoute::_($options['return']), sprintf (JText::_('PLG_USER_SPAMBOTCHECK_USER_LOGIN_SPAM_TXT')), "error");
			$app->close();
			return false;
		}
		
		return true;
	}
	
	
	/**
	 * Method check if the user specified is a spammer.
	 *
	 * @param 	array		holds the user data
	 * @param 	string		hold the raw string returned by "check_spammers_plain.php" 
	 * 
	 * @return boolean True if user is a spammer and False if he isn't. 
	 */
	function _isSpammer($user, &$spamString)
	{	
		//AVack:: 20101111 don't check admins
		if (!plgSpambotCheckHelpers::userIsAdmin($user))
		{
			//$fspamcheck = plgSpambotCheckImpl::checkSpambots($this->params, $user['email'], '59.173.26.161', $user['username']);
			$fspamcheck = plgSpambotCheckImpl::checkSpambots($this->params, $user['email'], $_SERVER['REMOTE_ADDR'], $user['username']);
			if ($fspamcheck == false || strlen($fspamcheck) == 0 || strpos($fspamcheck, "SPAMBOT_TRUE") === false)	
			{
				// not a spammer
				$spamString = "";
				return false;
			}
			// if we get here we have to deal with a spammer		
			$spamString = $fspamcheck;
			return true;
		}
		return false;
	}
	
	
	/**
	 * Send an e-mail about the failed login/register attempt to all admins.
	 *
	 * @param 	array		holds the user data
	 * @param 	string		hold the raw string returned by "check_spammers_plain.php"
	 * @param 	string		string added to the e-mail subject 
	 * 
	 * @return boolean True if user is a spammer and False if he isn't. 
	 */
	function _sendMailToAdmin(&$user, &$spamString, $subjectAddString)
	{	
		if (!$this->params->get('spbot_email_notifications', 1))	{
			// -> NO admin notifications
			return;
		}
		//get Super User Groups
		$superUserGroups = plgSpambotCheckHelpers::getSuperUserGroups();
		if ( !(count($superUserGroups) > 0) ) {
			// Something went wrong with finding superadmins, don't sent mails to everybody
			return;
		}
		// Only send notifications for selected types
		$type = $this->params->get('current_action');
		$notificationtype = $this->params->get('email_notification_type');
		
		if (($notificationtype == "RL") || ($notificationtype == "R" && $type == "Register") || ($notificationtype == "L" && $type == "Login"))
		{
			$name  = $user['fullname'];
			$username = $user['username'];
			$email = $user['email'];		
			$sPostersIP = $_SERVER['REMOTE_ADDR'];

		$app = JFactory::getApplication();
		$sitename 		= $app->getCfg( 'sitename' );
		$mailfrom 		= $app->getCfg( 'mailfrom' );
		$fromname 		= $app->getCfg( 'fromname' );

		//get all super administrator
		
		
		//create where statement for SQL
		$where = "";
		$length = count($superUserGroups);
		if ($length > 0 )
		{
			$where .= 'WHERE ';
			for ($i = 0; $i < $length; $i++) {
				$where .= 'map.group_id = '. $superUserGroups[$i];
				if ($i < $length - 1) {
					$where .= ' OR ';
				}
			}
		}

		$db		= JFactory::getDBO();
		$query = 'SELECT u.name AS name, u.email AS email, u.sendEmail AS sendEmail FROM `#__users` AS u LEFT JOIN `#__user_usergroup_map` AS map ON map.user_id = u.id LEFT JOIN `#__usergroups` AS g ON map.group_id = g.id ' . $where;
		$db->setQuery( $query );
		$rows = $db->loadObjectList();
		
		// Send notification to all administrators
		$subject2 = sprintf ( JText::_( 'PLG_USER_SPAMBOTCHECK_ACCOUNT_DETAILS_FOR_TXT' ), $name, $sitename) . $subjectAddString;
		$subject2 = html_entity_decode($subject2, ENT_QUOTES);

		foreach ( $rows as $row )
		{
			if ($row->sendEmail)
			{
				$message2 = sprintf ( JText::_( 'PLG_USER_SPAMBOTCHECK_SEND_EMAIL_TO_ADMIN_TXT' ), $row->name, $sitename, $type, $name, $email, $username, $sPostersIP, $spamString);
					$message2 = html_entity_decode($message2, ENT_QUOTES);
					$mailer = JFactory::getMailer();
					// Clean the email data
					$subject2 = JMailHelper::cleanSubject($subject2);
					$message2 = JMailHelper::cleanBody($message2);
					$mailer->sendMail($mailfrom, $fromname, $row->email, $subject2, $message2);
			}
		} 
	}	
		else
		{
			//No Admin Notification
			return;
		}
	}	
}
