<?php
/**
 * Helper for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Helper;

use Joomla\CMS\Factory;
use Joomla\CMS\Object\CMSObject;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\Helpers\Sidebar;

// no direct access
defined('_JEXEC') or die;

/**
 * Spambotcheck component helper.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_spambotcheck
 * @since		1.6
 */
class SpambotcheckHelper {
	public static $extension = 'com_spambotcheck';
	
	public static function addSubmenu($name) {
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_USERS'),
			'index.php?option=com_spambotcheck&view=users',
			$name == 'users'
		);
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_LOGS'),
			'index.php?option=com_spambotcheck&view=logs',
			$name == 'logs'
		);
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_HELP'),
			'index.php?option=com_spambotcheck&view=help',
			$name == 'help');
	}
	
	public static function getActions() {
		$user       = Factory::getUser();
		$result	    = new CMSObject();
		$actions    = array('core.admin', 'core.manage');

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, 'com_spambotcheck'));
		}

		return $result;
	}
}
