<?php
/**
 * Default controller for Spambotcheck
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Controller;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Input\Input;

// no direct access
defined('_JEXEC') or die;

class DisplayController extends BaseController {
	protected $default_view = 'users';

	public function __construct(array $config, ?MVCFactoryInterface $factory = null, ?CMSApplicationInterface $app = null, ?Input $input = null) {
		parent::__construct($config, $factory, $app, $input);
		// todo: clarify
		// make sure that English language files are always loaded, so that missing translations are taken from the English language files
		$language = Factory::getApplication()->getLanguage();
		$language->load('com_spambotcheck', JPATH_ROOT . '/administrator/components/com_spambotcheck' , 'en-GB', true);
		$language->load('com_spambotcheck', JPATH_ROOT . '/administrator/components/com_spambotcheck' , null, true);
		$language->load('com_spambotcheck', JPATH_ROOT . '/administrator' , 'en-GB', true);
		$language->load('com_spambotcheck', JPATH_ROOT . '/administrator' , null, true);
	}

	public function display($cachable = false, $urlparams = false) {
		// commented out for joomla 4
		// sub-menus are handled via administrator/components/com_spambotcheck/spambotcheck.xml:/extension/administration/submenu
		// load the sidebar submenu
		// SpambotcheckHelper::addSubmenu(Factory::getApplication()->input->get->get('view', 'users', 'cmd'));
		parent::display($cachable, $urlparams);
		return $this;
	}
}
