<?php
/**
 * Helper for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Helper;

use Joomla\CMS\Access\Access;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\Helpers\Sidebar;
use Joomla\Filesystem\Path;
use Joomla\Registry\Registry;

// no direct access
defined('_JEXEC') or die;

/**
 * Spambotcheck component helper.
 *
 * @package		Joomla.Administrator
 * @subpackage	com_spambotcheck
 * @since		1.6
 */
class SpambotcheckHelper {
	public static $extension = 'com_spambotcheck';
	
	public static function addSubmenu($name) {
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_USERS'),
			'index.php?option=com_spambotcheck&view=users',
			$name == 'users'
		);
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_LOGS'),
			'index.php?option=com_spambotcheck&view=logs',
			$name == 'logs'
		);
		Sidebar::addEntry(
			Text::_('COM_SPAMBOTCHECK_SUBMENU_HELP'),
			'index.php?option=com_spambotcheck&view=help',
			$name == 'help');
	}
	
	public static function getActions() {
		$user       = Factory::getApplication()->getIdentity();
		$result	    = new Registry(null, '');
		$actions = Access::getActionsFromFile(Path::clean(JPATH_ADMINISTRATOR . '/components/com_spambotcheck/access.xml'), "/access/section[@name='component']/");

		foreach ($actions as $action) {
			$result->set($action->name, $user->authorise($action->name, 'com_spambotcheck'));
		}

		return $result;
	}
}
