<?php
/**
 * Help model for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Model;

use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Event\DispatcherAwareTrait;
use Joomla\Event\DispatcherInterface;
use Joomla\CMS\Factory;


defined('_JEXEC') or die;

/**
 * Help model
 *
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2013 vi-solutions
 *
 * @since        Joomla 1.6 
 */
class HelpModel extends ListModel
{
	use DispatcherAwareTrait;
	public function __construct($config = array(), ?MVCFactoryInterface $factory = null) {
		parent::__construct($config, $factory);
  }

	public function getDispatcher() {
		if (!$this->dispatcher) {
			return Factory::getContainer()->get(DispatcherInterface::class);
		}
		return $this->dispatcher;

	}
}