<?php
/**
 * USERS table class for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Component\Spambotcheck\Administrator\Table;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseDriver;
use Joomla\Utilities\ArrayHelper;

// no direct access
defined('_JEXEC') or die;

class UsersTable extends Table {
	public function __construct(DatabaseDriver $db) {
		parent::__construct('#__user_spambotcheck', 'user_id', $db);
	}
	
	public function trust($pks = null, $state = 0) {
        // sanitize input
        ArrayHelper::toInteger($pks);
        $state = (int) $state;
		
		// if there are no primary keys nothing to do
		if (empty($pks)) {
			$this->setError(Text::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
			return false;
		}

		if (!is_array($pks)) {
			$pks = array($pks);
		}

		foreach ($pks as $key => $pk) {
			if (!is_array($pk)) {
				$pks[$key] = array($this->_tbl_key => $pk);
			}
		}

		foreach ($pks as $pk) {
			// get the JDatabaseQuery object
			$query = $this->_db->createQuery();
			// update the publishing state for rows with the given primary keys
			$query->update($this->_db->quoteName($this->_tbl));
			$query->set($this->_db->quoteName('trust') . ' = ' . (int) $state);
			if ((int) $state == 1) {
				$query->set($this->_db->quoteName('suspicious') . ' = ' . (int) 1);
			}
			$this->appendPrimaryKeys($query, $pk);
			try {
				// SQL errors
				$this->_db->setQuery($query);
				// DBMS errors
				$this->_db->execute();
			}
			catch (\RuntimeException $e) {
				// todo: clarify error handling method
				Factory::getApplication()->enqueueMessage($e->getMessage(), CMSApplicationInterface::MSG_ERROR);
				//$this->setError($e->getMessage());
				return false;
			}
		}
		
		$this->setError('');
 
        return true;
	}
}