<?php
/**
 * Users view for Spambotcheck
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotcheck
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Access\Access;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Visolutions\Component\Spambotcheck\Administrator\Service\HTML\JHTMLSpambotcheck;

// todo: clarify obsolete attribute 'width', like in <th width="3%">

// no direct access
defined('_JEXEC') or die;

HTMLHelper::_('bootstrap.tooltip');
HTMLHelper::_('dropdown.init');

$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('multiselect');

$listOrder              = $this->escape($this->state->get('list.ordering'));
$listDirection          = $this->escape($this->state->get('list.direction'));
$listDirectionReversed  = !strcasecmp($listDirection, 'ASC') ? 'DESC' : 'ASC';
$user                   = Factory::getApplication()->getIdentity();
?>

<form action="<?php echo Route::_('index.php?option=com_spambotcheck&view=users');?>" method="post" name="adminForm" id="adminForm"><?php
if (!empty( $this->sidebar)) : ?>
    <div id="j-sidebar-container" class="span2"><?php echo $this->sidebar; ?></div>
    <div id="j-main-container" class="span10"><?php
else : ?>
    <div id="j-main-container"><?php
endif;
    // todo: filter field 'range' with value set, does not put filters-bar to visible
    // search tools bar
    echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
	<div class="clearfix"></div>

	<table class="table table-striped">
	<thead><tr>
        <th width="3%">
            <?php echo HTMLHelper::_('grid.checkall'); ?>
        </th>
        <th width="3%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_ID', 'a.id', $listDirection, $listOrder); ?>
        </th>
        <th width="5%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_USER_ID', 'a.user_id', $listDirection, $listOrder); ?>
        </th>
        <th width="5%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_SUSPICIOUS', 'a.suspicious', $listDirection, $listOrder); ?>
        </th>
        <th width="4%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_TRUST', 'a.trust', $listDirectionReversed, $listOrder); ?>
        </th>
        <th class="nowrap" width="4%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_HEADING_ENABLED', 'block', $listDirection, $listOrder); ?>
        </th>
        <th class="nowrap" width="4%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_HEADING_ACTIVATED', 'activation', $listDirection, $listOrder); ?>
        </th>
        <th width="6%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_IP', 'a.ip', $listDirection, $listOrder); ?>
        </th>
        <th width="6%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_NAME', 'name', $listDirection, $listOrder); ?>
        </th>
        <th width="6%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_USERNAME', 'username', $listDirection, $listOrder); ?>
        </th>
        <th width="6%">
            <?php echo Text::_('COM_SPAMBOTCHECK_USER_GROUP_NAME'); ?>
        </th>
        <th width="12%">
                <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_EMAIL', 'email', $listDirection, $listOrder); ?>
        </th>
        <th width="10%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_REGISTERDATE', 'registerdate', $listDirection, $listOrder); ?>
        </th>
        <th width="23%">
            <?php echo Text::_( 'COM_SPAMBOTCHECK_NOTE' ); ?>
        </th>
        <th width="3%">
            <?php echo HTMLHelper::_('searchtools.sort', 'COM_SPAMBOTCHECK_HITS', 'a.hits', $listDirection, $listOrder); ?>
        </th>
    </tr></thead><?php

	$k = 0;
	$n = count( $this->items );
	for ($i=0; $i < $n; $i++) {
		$item       = $this->items[$i];
		$checked 	= HTMLHelper::_('grid.id',   $i, $item->user_id );
		$canChange	= $user->authorise('core.edit.state',	'com_users');
		// if this group is super admin and this user is not super admin, $canChange is false
		if ((!$user->authorise('core.admin')) && Access::check($item->user_id, 'core.admin', 'com_users')) {
			$canChange	= false;
		}
		$suspicious = !$item->suspicious ? HTMLHelper::_('image', 'administrator/components/com_spambotcheck/images/suspicious_16.png', Text::_('JYES')) : ''; ?>
		<tr class="row<?php echo $i % 2; ?>">
			<td class="center"><?php echo $checked; ?></td>
			<td><?php echo $this->escape($item->id); ?></td>
			<td class="center"><?php echo $this->escape($item->user_id); ?></td>
			<td class="center"><?php echo $suspicious;?></td>
			<td class="center"><?php
                if ($canChange) {
					echo HTMLHelper::_('jgrid.state', JHTMLSpambotcheck::trustStates(), $item->trust, $i, 'users.', true);
				}
                else {
	                echo Text::_($item->trust ? 'JYES' : 'JNO');
                } ?>
            </td>
			<td class="center"><?php
                if ($canChange) {
						$self = $user->id == $item->user_id;
					    echo HTMLHelper::_('jgrid.state', HTMLHelper::_('spambotcheck.blockStates', $self), $item->block, $i, 'users.', !$self);
				}
				else {
                    echo Text::_($item->block ? 'JNO' : 'JYES');
                } ?>
			</td>
			<td class="center"><?php
                if ($canChange) {
                    $activated = empty( $item->activation) ? 0 : 1;
                    if (empty($activated))  { ?>
                        <span class="icon-check" aria-hidden="true" aria-describedby="tip-activated<?php echo $i; ?>"></span>
                        <div role="tooltip" id="tip-activated<?php echo $i; ?>">
		                    <?php echo Text::_('COM_SPAMBOTCHECK_ACTIVATED'); ?>
                        </div>
                    <?php }
                    else {
	                    echo HTMLHelper::_('jgrid.state', HTMLHelper::_('spambotcheck.activateStates'), $activated, $i, 'users.', true);
                    }
				}
				else {
                    echo Text::_($item->activation ? 'JYES' : 'JNO');
                } ?>
			</td>
			<td class="center"><?php echo $this->escape($item->ip);?></td>
			<td class="center"><?php echo $this->escape($item->name); ?></td>
			<td class="center"><?php echo $this->escape($item->username); ?></td>
			<td class="center"><?php echo $item->group_names; ?></td>
			<td class="center"><?php echo $this->escape($item->email); ?></td>
			<td class="center"><?php echo HTMLHelper::_('date', $item->registerdate, 'Y-m-d H:i:s'); ?></td>
			<td class="center"><?php echo $this->escape($item->note); ?></td>
           	<td class="center"><?php echo $item->hits; ?></td>
		</tr><?php
		$k = 1 - $k;
	} ?>

    <tfoot><tr><td colspan="15"><?php echo $this->pagination->getListFooter(); ?></td></tr></tfoot>
	</table>
    <div>
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" /><?php
        echo HTMLHelper::_('form.token'); ?>
    </div><?php
        HTMLHelper::_('spambotcheck.description', 'users');
        HTMLHelper::_('spambotcheck.creditsBackend'); ?>
    </div>
</form>