<?php

/**
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_spambotchek
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 5.0.0
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Visolutions\Plugin\User\Spambotcheck\Extension\Spambotcheck;

return new class () implements ServiceProviderInterface {
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin = new Spambotcheck (
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('user', 'spambotcheck')
                );
				// When, why, and how do we need this ?
                // $plugin->setApplication(Factory::getApplication());
                $plugin->setDatabase($container->get(DatabaseInterface::class));

                return $plugin;
            }
        );
    }
};
