<?php
/**
 * Field - Component Params Description for Spambotcheck
 *
 * @author		 vi-solutions, Aicha Vack & Ingmar Vack
 * @package		 User SpambotCheck - check for possible spambots during register and login
 * @subpackage   Field - Component Params Description
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2021 vi-solutions
 * @since        Joomla 4.0
 */
namespace Visolutions\Plugin\User\Spambotcheck\Field;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;

// no direct access
defined('_JEXEC') or die;

class ComponentregexsamplesipField extends FormField {
    protected $type = 'componentregexsamplesip';

	protected function getLabel() {
		return Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_IP_LABEL');
	}

	protected function getInput() {
	    return $this->renderInput();
    }

	private function renderInput() {
		return '
		<div>
		<strong>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_IP_DESC_T1') . '</strong>
		<p>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ATT1') . '</p>
		</div>
		<table class="regex-sample-ip" style="padding: 5px;" xmlns="https://www.w3.org/1999/html">
		<thead><tr><th>IP</th><th>RegEx</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_RESULT') . '</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_REMARK') . '</th></tr></thead>
		<tr><td>127.0.0.1</td><td>127\.0\.0\.1</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.12</td><td>127\.0\.0\.1</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.12</td><td>127\.0\.0\.1$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.12</td><td>27\.0\.0\.12$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_AMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.12</td><td>^27\.0\.0\.12$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>27.0.0.12</td><td>^27\.0\.0\.12$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		</table>
		<div>
		<br/>
		<strong>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_IP_DESC_T2') . '</strong>
		<p>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ATT3') . '</p>
		</div>
		<table class="regex-sample-ip" style="padding: 5px;" xmlns="https://www.w3.org/1999/html">
		<thead><tr><th>IP</th><th>RegEx</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_RESULT') . '</th><th>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_REMARK') . '</th></tr></thead>
		<tr><td>127.0.0.1</td><td>^127\.0\.0\.1\d{0,2}$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.12</td><td>^127\.0\.0\.1\d{0,2}$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.123</td><td>^127\.0\.0\.1\d{0,2}$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_ACCEPTED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		<tr><td>127.0.0.2</td><td>^127\.0\.0\.1\d{0,2}$</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_BLOCKED') . '</td><td>' . Text::_('PLG_USER_SPAMBOTCHECK_REGEX_SAMPLES_DESC_UNAMBIGUOUS') . '</td></tr>
		</table>
		';
	}
}
