<?php
/**
 * Visform view for Visforms
 *
 * @author       Aicha Vack
 * @see           visforms is extended and rivised adaptation of ckforms from cookex (http://www.cookex.eu) for Joomla 2.5
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view' );

/**
 * visform view to show a singl field
 *
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since        Joomla 1.6 
 */
class VisformsViewVisform extends JView
{
	protected $canDo;
	protected $form;
	protected $item;
	
	/**
	 * Visform view display method
	 *
	 * @return void
	 **/
	function display($tpl = null)
	{		
		$document = JFactory::getDocument();
		$css = '.icon-48-visform {background:url(../administrator/components/com_visforms/images/logo-banner.png) no-repeat;}';
   		$document->addStyleDeclaration($css);
		
		// What Access Permissions does this user have? What can (s)he do?                
		$this->form		= $this->get('Form');
		$this->item		= $this->get('Item');	
		$this->canDo = VisformsHelper::getActions($this->item->id);		
		$user		= JFactory::getUser();
		$userId		= $user->get('id');
		$checkedOut	= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
                $isNew		= ($this->item->id == 0);
		$text = $isNew ? JText::_( 'COM_VISFORMS_NEW' ) : JText::_( 'COM_VISFORMS_EDIT' );
                JToolBarHelper::title(JText::_( 'COM_VISFORMS' ).': <small><small>[ ' . $text.' ]</small></small>' , 'visform' );
		
		if ($isNew)  {
			if ($this->canDo->get('core.create')) {
				JToolBarHelper::apply('visform.apply');
				JToolBarHelper::save('visform.save');
				JToolBarHelper::save2new('visform.save2new');
				JToolBarHelper::divider();
				JToolBarHelper::custom('visform.fields','edit.png','edit.png','COM_VISFORMS_FIELDS',false) ;
				JToolBarHelper::divider();
			}
			JToolBarHelper::cancel('visform.cancel');
		} else {
			// Can't save the record if it's checked out.
			if (!$checkedOut) {
				if ($this->canDo->get('core.edit') || ($this->canDo->get('core.edit.own') && $this->item->created_by == $userId)) {
					JToolBarHelper::apply('visform.apply');
					JToolBarHelper::save('visform.save');
					if ($this->canDo->get('core.create')) {
						JToolBarHelper::save2new('visform.save2new');
					}
				}
			}

			if ($this->canDo->get('core.create')) {
				JToolBarHelper::save2copy('visform.save2copy');
			}
			
			if (!$checkedOut) {
				if ($this->canDo->get('core.edit')) {
					JToolBarHelper::divider();
					JToolBarHelper::custom('visform.fields','edit.png','edit.png','COM_VISFORMS_FIELDS',false) ;
					JToolBarHelper::divider();
				}
			}
			// for existing items the button is renamed `close`
			JToolBarHelper::cancel( 'visform.cancel', 'COM_VISFORMS_CLOSE' );
		}

		
		JRequest::setVar( 'hidemainmenu', 1 );
		$document->addStyleSheet(JURI::root(true).'/administrator/components/com_visforms/css/visforms.css');
		

		
		parent::display($tpl);
	}
}
