<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

$published = $this->state->get('filter.published');
?>
<fieldset class="batch">
	<legend><?php echo JText::_('COM_VISFORMS_BATCH_OPTIONS');?></legend>
	<?php echo JHtml::_('batch.access');?>
	<?php echo JHtml::_('batch.language'); ?>
	<?php

		// Create the copy/move options.
		$options = array(JHtml::_('select.option', 'c', JText::_('JYes')),
			JHtml::_('select.option', 'n', JText::_('JNo')));

		// Create the batch selector to select whether to copy fields or not.
		$lines = array('<label id="batch-choose-action-lbl" for="batch-choose-action">', JText::_('COM_VISFORMS_COPY_FIELDS'), '</label>',
			'<fieldset id="batch-choose-action" class="combo">',
			//show the radiolist with default 0
			JHtml::_('select.radiolist', $options, 'batch[copy_fields]', '', 'value', 'text', 'c'), '</fieldset>');

		echo implode("\n", $lines);
	?>

	<button type="submit" onclick="Joomla.submitbutton('visform.batch');">
		<?php echo JText::_('JGLOBAL_BATCH_PROCESS'); ?>
	</button>
	<button type="button" onclick="document.id('batch-access').value='';document.id('batch-language-id').value=''; document.id('batch[copy_fields]c').checked=true;document.id('batch[copy_fields]n').checked=false">
		<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>
	</button>
</fieldset>
