<?php

/**
 * editor class	for visforms
 * @author       Aicha Vack
 * @see           visforms is extended and rivised adaptation of ckforms from cookex (http://www.cookex.eu) for Joomla 2.5
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
// no direct access
defined('_JEXEC') or die('Restricted access');


class VisformsEditorHelper
{
   
        
        /**
	 * Initialises the Editor.
	 *
	 * @return  string  JavaScript Initialization string
	 *
	 * @since 1.5
	 */
	public static function initEditor()
        {
            $basePath = 'media/editors/tinymce/jscripts/tiny_mce';
            $app = JFactory::getApplication();
            $language	= JFactory::getLanguage();
            $text_direction = 'ltr';
            if ($language->isRTL())
            {
                    $text_direction = 'rtl';
            }
            $entity_encoding	=  'raw';

            $langMode		=  0;
            $langPrefix		= 'en';

            if ($langMode)
            {
                    $langPrefix = substr($language->getTag(), 0, strpos($language->getTag(), '-'));
            }
            $newlines			=  1;

            if ($newlines)
            {
                    // br
                    $forcenewline = "force_br_newlines : true, force_p_newlines : false, forced_root_block : '',";
            }
            else
            {
                    // p
                    $forcenewline = "force_br_newlines : false, force_p_newlines : true, forced_root_block : 'p',";
            }

            $invalid_elements	= 'script,applet,iframe';
            $skin = 'skin : "default",';
            $relative_urls = "false";
            $load = "\t<script type=\"text/javascript\" src=\"".
            JURI::root().$basePath.
                            "/tiny_mce.js\"></script>\n";

            $return = $load .
            "\t<script type=\"text/javascript\">
            tinyMCE.init({
                    // General
                    directionality: \"$text_direction\",
                    editor_selector : \"mce_editable\",
                    plugins : \"-test\",
                    language : \"". $langPrefix . "\",
                    mode : \"specific_textareas\",
                    $skin
                    theme : \"simple\",
                    // Cleanup/Output
                    inline_styles : true,
                    gecko_spellcheck : true,
                    entity_encoding : \"$entity_encoding\",
                    $forcenewline
                    // URL
                    relative_urls : $relative_urls,
                    remove_script_host : false,
                    // Layout
                    
                    document_base_url : \"". JURI::root() ."\",
            });
            </script>";
            $doc = JFactory::getDocument();
            $doc->addCustomTag($return);
            return true;
        }
}
