drop table if exists #__visforms;

create table #__visforms
(
   id                           int(11) not null AUTO_INCREMENT,
   asset_id INTEGER UNSIGNED NOT NULL DEFAULT 0,
   name                         text,
   title                        text,
   checked_out 					int(10) NOT NULL default '0',
   checked_out_time datetime NOT NULL default '0000-00-00 00:00:00',
   description                  longtext,
   emailfrom                    text,
   emailfromname				text,
   emailto                      text,
   emailcc                      text,
   emailbcc                     text,
   subject						text,	
   created                      datetime NOT NULL default '0000-00-00 00:00:00',
   created_by                   int(11) NOT NULL default 0,
   hits                         int(11) NOT NULL default '0',
   published                    tinyint NOT NULL default 0,
   saveresult                   tinyint,
   emailresult                  tinyint,
   textresult                   longtext,
   redirecturl					text,
   spambotcheck                 tinyint(1) NOT NULL default '0',
   captcha                    	tinyint,
   uploadpath					text,
   maxfilesize					int,
   allowedextensions			text,
   savemode                       tinyint(1) NOT NULL default '0',
   poweredby                   	tinyint,
   emailreceipt                 tinyint,
   emailreceipttext             longtext,
   emailreceiptsubject			text,
   emailreceiptfrom             text,
   emailreceiptfromname         text,
   emailreceiptsettings			text,
   emailresulttext              longtext,
   emailresultsettings			text,
   editemailresultsettings              longtext,
   editemailreceiptsettings              longtext,
   fronttitle                   text,
   frontdescription             longtext,
   frontendsettings				text,
   access                       int(11) NOT NULL default '0',   
   language                     char(7) NOT NULL,  
   exportsettings               text,
   layoutsettings               longtext,
   spamprotection               text,
   captchaoptions               text,
   viscaptchaoptions            text,
  redirecttoeditview              tinyint(1) not null DEFAULT 0,
  subredirectsettings			text,
  savesettings			text,
   primary key (id)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

drop table if exists #__visfields;

create table #__visfields
(
   id                           int(11) not null AUTO_INCREMENT,
   fid                          int(11),
   asset_id INTEGER UNSIGNED NOT NULL DEFAULT 0,
   name                         text,
   label                  	    text,
   checked_out 					int(10) NOT NULL default '0',
   checked_out_time datetime NOT NULL default '0000-00-00 00:00:00',
   created                      datetime NOT NULL default '0000-00-00 00:00:00',
   created_by                   int(11) NOT NULL default '0',
   typefield                    text,
   defaultvalue					longtext,
   published                    tinyint NOT NULL default 0,
   ordering                     int(11) not null DEFAULT 0, 
   labelCSSclass				text,
   fieldCSSclass				text,
   bootstrap_size               tinyint(3) UNSIGNED NOT NULL default 0,
   customtext					text,
   frontdisplay					tinyint,
   frontaccess                  int(11) NOT NULL default '0',
   includefieldonexport         tinyint(4) not null DEFAULT 1,
   allowurlparam                tinyint(4) not null DEFAULT 0,
   customtextposition           tinyint(4) not null DEFAULT 0,
   uniquevaluesonly             tinyint(4) not null DEFAULT 0,
   restrictions                 text,
   editonlyfield                tinyint(1) NOT NULL default 0,
   addtoredirecturl             tinyint(1) NOT NULL default 0,
   rdtparamname text NOT NULL DEFAULT '',
   includeinresultmail          tinyint(1) NOT NULL default 1,   
   includeinreceiptmail         tinyint(1) NOT NULL default 1,
   useoptionvalueinplaceholder         tinyint(1) NOT NULL default 0,
   customlabelformail text,
   customlabelforcsv text,
   fileexportformat tinyint(1) NOT NULL default 0,
   displayAsMapInList tinyint(1) NOT NULL default 0,
   displayAsMapInDetail tinyint(1) NOT NULL default 0,
   listMapHeight CHAR(10) NOT NULL DEFAULT '',
   detailMapHeight CHAR(10) NOT NULL DEFAULT '',
   listMapZoom INT (11) NOT NULL DEFAULT 8,
   detailMapZoom INT (11) NOT NULL DEFAULT 13,
   allowferadiussearch tinyint(1) NOT NULL default 0,
   distanceunit CHAR(10) NOT NULL DEFAULT 'km',
   useassearchfieldonly tinyint(1) NOT NULL default 0,
   displayImgAsImgInList tinyint(1) NOT NULL default 0,
   displayImgAsImgInDetail tinyint(1) NOT NULL default 0,
   dataordering int(11) not null DEFAULT 0,
   primary key (id)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

drop table if exists #__visverificationcodes;
create table #__visverificationcodes (
  id  int(11) not null AUTO_INCREMENT,
  fid int(11) NOT NULL DEFAULT 0,
  created  datetime NOT NULL default '0000-00-00 00:00:00',
  email        varchar(100) default ''  not null,
  code         varchar(30) default ''    not null,
  KEY `idx_email` (`email`),
  KEY `idx_fid` (`fid`),
  primary key (id)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;