<?php
/**
 * Visforms HTML class for file fields
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         http://www.vi-solutions.de 
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
require_once(__DIR__ . '/text.php');

/**
 * Create HTML of a file field according to it's type
 *
 * @package		Joomla.Site
 * @subpackage	com_visforms
 * @since		1.6
 */
class VisformsHtmlFile extends VisformsHtmlText
{     
    /**
     * 
     * Constructor
     * 
     * @param object $field field object as extracted from database
     */
    public function __construct($field, $decorable, $attribute_type)
    {
        $attribute_type = "file";
        parent::__construct($field, $decorable, $attribute_type);
    }

    /**
     * Method for the individual field type specific removal of bootstrap class attributes (no removal for buttons)
     * @param object $field
     * @return object field
     */
    public function removeNoBootstrapClasses($field)
    {
        if ((isset($field->attribute_class)))
        {
            $field->attribute_class = '';
        }
        return $field;
    }
}