<?php
/**
 * Mod_Visforms Form
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   mod_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Helper\ModuleHelper;

/** @var object $visforms */
/** @var object $menu_params */
/** @var object $params */

$currentDate = Factory::getDate()->format('Y-m-d H:i:s');
$isNotPublishedYet = $visforms->publish_up > $currentDate;
$isExpired = !is_null($visforms->publish_down) && $visforms->publish_down < $currentDate;

// empty page, if form is not published
if ($visforms->published != '1') {
    return $visforms;
}
// empty page, if form is published down
if ($isNotPublishedYet || $isExpired) {
    return $visforms;
}
HTMLHelper::_('bootstrap.framework');

// retrieve helper variables from params
$nbFields=$params->get('nbFields');
$required = $params->get('required');
$upload = $params->get('upload');
$textareaRequired = $params->get('textareaRequired');
$hasHTMLEditor = $params->get('hasHTMLEditor');
$return = HTMLHelper::_('visforms.base64_url_encode', Uri::getInstance()->toString());
$firstControl = $params->get('firstControl');
$setFocus = $params->get('setFocus');
$steps = $params->get('steps');
$context = $params->get('context');
$successMessage = $params->get('successMessage');
// used to disable ajax request if form is displayed in Yootheme Builder context
$previewOnly = $params->get('previewOnly');
echo LayoutHelper::render('visforms.custom.noscript', array(), null, array('component' => 'com_visforms'));
?>

<div class="visforms visforms-form visforms-form-form mod-visforms"><?php
    if (isset($visforms->errors) && is_array($visforms->errors) && count($visforms->errors) > 0) {
	    echo LayoutHelper::render('visforms.error.messageblock', array('errormessages' => $visforms->errors, 'context' => 'form'), null, array('component' => 'com_visforms'));
    }

    if ($menu_params->get('show_title') == 1) {?>
		<h1><?php echo $visforms->title; ?></h1><?php
	}

	echo LayoutHelper::render('visforms.success.messageblock', array('message' => $successMessage, 'parentFormId' => $visforms->parentFormId, 'fid' => $visforms->id), null, array('component' => 'com_visforms'));?>

    <div class="alert alert-danger error-note" style="display: none;"></div><?php
	echo LayoutHelper::render('visforms.scripts.validation', array('visforms' => $visforms, 'textareaRequired' => $textareaRequired, 'hasHTMLEditor' => $hasHTMLEditor, 'parentFormId' => $visforms->parentFormId, 'steps' => $steps), null, array('component' => 'com_visforms'));
    if (strcmp ( $visforms->description , "" ) != 0) { ?>
        <div class="category-desc"><?php
            PluginHelper::importPlugin('content');
            echo HTMLHelper::_('content.prepare', $visforms->description); ?>
        </div><?php
    }

    // display form with appropriate layout
	switch($visforms->formlayout) {
		case 'btdefault' :
		case 'bthorizontal' :
		case 'bt3default' :
		case 'bt3horizontal' :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_btdefault');
			break;
		case  'mcindividual' :
		case  'bt3mcindividual' :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_mcindividual');
			break;
		case  'bt4mcindividual' :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_bt4mcindividual');
			break;
        case  'bt5' :
            require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_bt5');
            break;
		case  'uikit2' :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_uikit2');
			break;
		case  'uikit3' :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_uikit3');
			break;
		default :
			require ModuleHelper::getLayoutPath('mod_visforms', $params->get('layout', 'default') . '_visforms');
			break;
	}

    if ($visforms->poweredby == '1') {
        echo HTMLHelper::_('visforms.creditsFrontend');
    }
    if (!empty($visforms->showmessageformprocessing)) { ?>
        <div id="<?php echo $visforms->parentFormId; ?>_processform" style="display:none"><div class="processformmessage"><?php
                echo $visforms->formprocessingmessage; ?>
            </div></div><?php
    }
    echo LayoutHelper::render('visforms.scripts.map', array('form' => $visforms), null, array('component' => 'com_visforms'));
	echo LayoutHelper::render('visforms.scripts.searchableselect', array('form' => $visforms), null, array('component' => 'com_visforms'));?>
</div>
