<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 * @since        Joomla 3.0.0
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;

$canCreateSQL = Factory::getApplication()->getIdentity()->authorise('core.create.sql.statement', 'com_visforms');
$emptyMessage = Text::_('COM_VISFORMS_EMPTY_SQL_STATEMENT', true);
$token = Session::getFormToken();
// disable click event if user has no permission to create sql
$onclick = $canCreateSQL ? 'onclick="'.$displayData['task'].'(event, this, \''.$emptyMessage.'\', \''. $token . '\');"' : 'onclick="event.preventDefault();"';
?>
<div class="sql-edit-controls"> <?php
    echo $displayData['input']; ?>
    <button class="btn btn-success ms-0 mt-1" style="" type="" <?php echo $onclick; ?>><span class="icon_ajax-wait icon-spinner spinner-border-sm" aria-hidden="true"></span> <?php echo Text::_('COM_VISFORMS_PDF_BUTTON_TEST');?></button>
    <div class="sql-message-field"></div>
</div>