<?php
/**
 * Itemlist controller for Visforms
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Controller;

defined('_JEXEC') or die( 'Restricted access' );

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Language\Text;

class ItemControllerBase extends FormController
{
	protected $app;
	public function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null, FormFactoryInterface $formFactory = null) {
		parent::__construct($config, $factory, $app, $input);
		$this->app = Factory::getApplication();
		$test = true;
		// $this->registerTask('showStepBadges', 'hideStepBadges');
	}

	protected function getAjaxRequestData() {
		// get the data
		$input = $this->app->input;
		$json = $input->get('data', '', 'raw');
		$data = json_decode($json);
		return $data;
	}

	protected function checkAjaxSessionToken() {
		$data = $this->getAjaxRequestData();
		$token = Session::getFormToken();
		if ((!isset($data->$token)) || !((int) $data->$token === 1)) {
			return false;
		}
		return true;
	}

    public function saveAjaxTextarea() {
	    if (!Session::checkToken()) {
            $message = Text::_("COM_VISFORMS_AJAX_INVALID_TOKEN");
            $success = false;
        }
        else {
            $model = $this->getModel();
            $success = $model->saveAjaxTextareaInDatabase();
            if ($success === false) {
                $errors = $model->getErrors();
                // Push one error messages into the response
                for ($i = 0, $n = count($errors); $i < $n && $i < 1; $i++) {
                    if ($errors[$i] instanceof \Exception) {
                        $message = $errors[$i]->getMessage();
                    } else {
                        $message = $errors[$i];
                    }
                }
            }
            else {
                $message = Text::_('COM_VISFORMS_AJAX_SUBMIT_SUCCESS_MESSAGE');
            }
        }


        ob_clean();
        $response = array("success" => $success, 'message' => $message, 'result' => true);
        $document = $this->app->getDocument();
        $document->setMimeEncoding('application/json');
        echo json_encode($response);
        $this->app->close();
    }

	// stored for later use
	/*public function hideStepBadges() {
		if ('hideStepBadges' === $this->getTask()) {
			$this->storeParam('hideStepBadges', 1);
		}
		else {
			$this->storeParam('hideStepBadges', 0);
		}
		$this->setRedirect(Route::_('index.php?option=com_visforms&view=visfields' . $this->getRedirectToListAppend(), false));
	}*/

	/*protected function storeParam($name, $value) {
		$component = ComponentHelper::getComponent('com_visforms');
		$component->params->set($name, $value);
		$componentId = $component->id;
		$table = Table::getInstance('extension');
		$table->load($componentId);
		$table->bind(array('params' => $component->params->toString()));
		if (!$table->check()) {
			Factory::getApplication()->enqueueMessage('Invalid params', 'error');
			return false;
		}
		if (!$table->store()) {
			Factory::getApplication()->enqueueMessage('Problems saving params', 'error');
			return false;
		}
		return true;
	}*/
}