<?php
/**
 * VisformsAfterBatchCopyForm Event for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.0.0
 */

namespace Visolutions\Component\Visforms\Administrator\Event\Visforms;
// phpcs:disable PSR1.Files.SideEffects
use Joomla\CMS\Event\Result\ResultAware;
use Joomla\CMS\Event\Result\ResultTypeBooleanAware;

\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

class VisfieldAfterBatchCopyFormEvent extends VisformsAbstractEvent {

    public function __construct($name, array $arguments = []) {
        parent::__construct($name, $arguments);

        if (!\array_key_exists('pk', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'pk' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('newId', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'newId' of event {$name} is required but has not been provided");
        }
    }

    public function getPk(): int {
        return $this->arguments['pk'];
    }

    public function getNewId(): int {
        return $this->arguments['newId'];
    }

}