<?php

/**
 * Visform field fieldorder
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Field;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\Database\ParameterType;

defined('_JEXEC') or die;


class FieldOrderingField extends ListField  {
    protected $type = 'FieldOrdering';


    protected function getOptions() {
        if (!(empty($this->element['prefix']))) {
            $fieldName = $this->element['prefix'] . 'ordering';
        }
        else {
            $fieldName = 'ordering';
        }
        $options = [];

        // Get the parent
        $fid = (int) $this->form->getValue('fid', 0);

        if (!$fid) {
            return false;
        }

        $db    = $this->getDatabase();
        $query = $db->createQuery()
            ->select(
                [
                    $db->quoteName('id', 'value'),
                    $db->quoteName('label', 'text'),
                ]
            )
            ->from($db->quoteName('#__visfields'))
            ->where($db->quoteName('fid') . ' = :fid')
            ->bind(':fid', $fid, ParameterType::INTEGER);

        $query->order($db->quoteName($fieldName) . ' ASC');

        // Get the options.
        try {
            $db->setQuery($query);
            $options = $db->loadObjectList();
        }
        catch (\RuntimeException $e) {
            Factory::getApplication()->enqueueMessage($e->getMessage(), 'error');
        }

        $options = array_merge(
            [['value' => '-1', 'text' => Text::_('COM_VISFORMS_FIELD_ORDERING_VALUE_FIRST')]],
            $options,
            [['value' => '-2', 'text' => Text::_('COM_VISFORMS_FIELD_ORDERING_VALUE_LAST')]]
        );

        // Merge any additional options in the XML definition.
        $options = array_merge(parent::getOptions(), $options);

        return $options;
    }

    protected function getInput() {
        if ($this->form->getValue('id', 0) == 0) {
            return '<span class="readonly">' . Text::_('COM_VISFORMS_FIELD_ORDERING_TEXT') . '</span>';
        }

        return parent::getInput();
    }
}
