<?php

/**
 * Visform field Selectfromdb
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Field;

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseInterface;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

class VfMenuListField extends ListField
{

	public $type = 'VfMenuList';

	protected function getInput() {
		// Get the field options.
        $options = array_merge($this->getOptions(), $this->getCustomOptions());
		$data = $this->getLayoutData();
		$data['options'] = (array) $options;
		return $this->getRenderer($this->layout)->render($data);
	}

    private function getCustomOptions() {
        $hasSaveResult = $this->getHasSaveResult();
        $hasSub = AefHelper::checkAEF();
        $options = array();
        // $options[] = array('value' => "index.php?option=com_visforms&view=viscpanel", 'text' => Text::_('COM_VISFORMS_SUBMENU_CPANEL_LABEL'));
        $options[] = array('value' => "visforms", 'text' => Text::_('COM_VISFORMS_SUBMENU_FORMS'));
        // $options[] = array('value' => "index.php?option=com_visforms&view=viscreator", 'text' => Text::_('COM_VISFORMS_CREATOR'));
        // $options[] = array('value' => "index.php?option=com_visforms&view=visinspector", 'text' => Text::_('COM_VISFORMS_SUBMENU_INSPECTOR'));
        $options[] = array('value' => "visfields", 'text' => Text::_('COM_VISFORMS_FORM_FIELDS'));
        if ($hasSub) {
            $options[] = array('value' => "vispdfs", 'text' => Text::_('COM_VISFORMS_PDF_TEMPLATES'));
        }
        if ($hasSaveResult) {
            $options[] = array('value' => "visdatas", 'text' => Text::_('COM_VISFORMS_VISFORMSDATA_VIEW_DEFAULT_TITLE'));
        }
        return $options;
    }

    private function getHasSaveResult(): bool {
        $fid = Factory::getApplication()->getInput()->get('fid', 0, 'int');
        // no form selected yet, we dispaly all possible options
        if (empty ($fid)) {
            return true;
        }
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->createQuery();
        $query->select($db->quoteName('saveresult'))
            ->from($db->quoteName('#__visforms'))
            ->where($db->quoteName('id') . ' = ' . $fid );
        // Get the options
        try {
            $db->setQuery($query);
            $saveresult =  $db->loadResult();
            if (!empty($saveresult)) {
                return true;
            }
        }
        catch (\RuntimeException $e) {
            return false;
        }
        return false;
    }
}
