<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2025 vi-solutions
 * @since        Visforms 5.4.0
 */

namespace Visolutions\Component\Visforms\Administrator\Model\Helper;

/*
Remove typefield prefix from field parameter in defaultvalue parameter
Set renamed parameter as property of field object
Possibly Remove defaultvalue property from field object
*/


class FieldParamNameShortener {

	private $field;

	public function __construct($field) {
		$this->field = $field;
	}

    // make names shorter and set all default values as properties of field object
    public function makeShort($clean = true) {
	    $field = $this->field;
        foreach ($field->defaultvalue as $name => $value) {
            // make names shorter and set all default values as properties of field object
            $prefix = 'f_' . $field->typefield . '_';
            if (str_contains($name, $prefix)) {
                $key = str_replace($prefix, "", $name);
                $field->$key = $value;
            }
        }
        $this->field = $field;
        if ($clean) {
            $this->deleteDefaultvalueParam();
        }
        return $this->field;
    }

    private function deleteDefaultvalueParam() {
        // delete default value array
        unset($this->field->defaultvalue);
    }
}