<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 * @since        Joomla 3.0.0
 */

namespace Visolutions\Component\Visforms\Administrator\Model;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Language\Text;
use Joomla\Event\DispatcherAwareTrait;
use Joomla\Event\DispatcherInterface;

class ItemModelBase extends AdminModel
{
	use DispatcherAwareTrait;
    protected $item;

    public function __construct($config = array(), ?MVCFactoryInterface $factory = null, ?FormFactoryInterface $formFactory = null) {
        parent::__construct($config, $factory, $formFactory);
	    $this->user = Factory::getApplication()->getIdentity();
    }

	public function getDispatcher() {
		if (!$this->dispatcher) {
			return Factory::getContainer()->get(DispatcherInterface::class);
		}
		return $this->dispatcher;
	}

    public function getForm($data = array(), $loadData = true) { }

    public function getItem($pk = null) {
        if (isset($this->item)) {
            // item already loaded and processed
            return $this->item;
        }
        if($this->item = parent::getItem($pk)) {
            // sub class: format the fields parameters
            $this->loadFormFieldsParameters();
        }
        return $this->item;
    }

    // try to save data in database
    // return appropriate message
    /* supported post and get parameter
        $id = $input->get('id', 0, 'int'); // record ic
        $fieldName = $input->post->get('fieldName', '', 'string');
        $tableName = $input->post->get('tableName', '', 'string');
        $text = ComponentHelper::filterText($this->app->getInput();->post->get('text', '', 'raw'));
        @throws \UnexpectedValueException (extends \RuntimeException)
        @throws \RuntimeException
    */
    public function saveAjaxTextareaInDatabase() {
        $input = Factory::getApplication()->getInput();
        // always the record id of the form
        $id = $input->get('id', 0, 'int');
        if (empty($id)) {
            throw new \UnexpectedValueException(Text::_('COM_VISFORMS_AJAX_SUBMIT_FORM_NOT_YET_SAVE_MESSAGE'));
        }
        $fieldName = $input->post->get('fieldName', '', 'string');
        $tableName =  $input->post->get('tableName', '', 'string');
        $viewTableName = $this->getTable()->getTableName();
        $key = 'id';
        // ComponentHelper::filterText: Apply Black and Whitelist according to user group settings: use HTML Filter rule;
        // Alternatively just use html filter
        $text = ComponentHelper::filterText($input->post->get('text', '', 'raw'));
        if (!empty($tableName) ) {
            $tableName = '#__' .$tableName;
            if ($tableName !== $viewTableName) {
                // visforms plugin with own data table
                // store in plugin table
                // may be refinded later using an event and using plugin code ot store the data in the data base.
                // use field fid in plugin data tables
                $key = 'fid';
            }
        }
        $datas = new \StdClass();
        $datas->$key = $id;
        $datas->$fieldName = $text;
        $db = $this->getDatabase();
        try {
            $db->updateObject($tableName, $datas, $key, false);
        }
        catch (\RuntimeException $e) {
            // Just pass it through
            throw new \RuntimeException($e->getMessage());
        }
    }

    protected function loadFormFieldsParameters() { }
}