<?php
/**
 * visfields model for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

namespace Visolutions\Component\Visforms\Administrator\Model;

defined('_JEXEC') or die();

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Language\Text;
use Joomla\Database\ParameterType;
use Joomla\Utilities\ArrayHelper;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class VisfieldsModel extends ItemsModelBase
{
    protected $hasSub;
    protected $subscriptionViewFields = array('editonlyfield', 'a.editonlyfield','frontaccess', 'a.frontaccess', 'access_level', 'required', 'readonly', 'showlabel');
	public function __construct($config = array(), ?MVCFactoryInterface $factory = null) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'label', 'a.label',
				'published', 'a.published',
				'typefield', 'a.typefield',
				'ordering', 'a.ordering',
				'dataordering', 'a.dataordering',
				'frontdisplay', 'a.frontdisplay',
			);
			$this->hasSub = AefHelper::checkAEF();
			if ($this->hasSub) {
                $config['filter_fields'] = array_merge($config['filter_fields'], $this->subscriptionViewFields);
            }
		}
		parent::__construct($config, $factory);
	}
	
	protected function populateState($ordering = null, $direction = null) {
		// Initialise variables.
		$app = Factory::getApplication();
		$input = $app->getInput();
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		$published = $this->getUserStateFromRequest($this->context.'.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);
		$editonlyfield = $this->getUserStateFromRequest($this->context.'.filter.editonlyfield', 'editonlyfield', '');
		$this->setState('filter.editonlyfield', $editonlyfield);
        $required= $this->getUserStateFromRequest($this->context.'.filter.required', 'required', '');
        $this->setState('filter.required', $required);
        $readonly = $this->getUserStateFromRequest($this->context.'.filter.readonly', 'readonly', '');
        $this->setState('filter.readonly', $readonly);
        $showlabel = $this->getUserStateFromRequest($this->context.'.filter.showlabel', 'showlabel', '');
        $this->setState('filter.showlabel', $showlabel);
        // $this->setState('filter.fid', $this->getUserStateFromRequest($this->context . '.filter.fid', 'filter_fid', $input->get('fid'), 'int'));

        $formSubmitted = $input->post->get('form_submitted');
        $this->getUserStateFromRequest($this->context . '.filter.frontaccess', 'filter_frontaccess');
        $this->getUserStateFromRequest($this->context.'.filter.frontdisplay', 'filter_frontdisplay', '');
        $this->getUserStateFromRequest($this->context.'.filter.typefield', 'typefield', '');

        if ($formSubmitted) {
            $access = $input->post->get('frontaccess');
            $this->setState('filter.frontaccess', $access);
            $frontdisplay = $input->post->get('frontdisplay');
            $this->setState('filter.frontdisplay', $frontdisplay);
            $typefield = $input->post->get('typefield');
            $this->setState('filter.typefield', $typefield);
        }
		// list state information.
		parent::populateState('a.id', 'asc');
        // force a language
		$forcedLanguage = $app->getInput()->get('forcedLanguage');
		if (!empty($forcedLanguage)) {
			$this->setState('filter.language', $forcedLanguage);
			$this->setState('filter.forcedLanguage', $forcedLanguage);
		}
	}
	
	protected function getStoreId($id = '') {
		// compile the store id
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.published');
        $id	.= ':'.serialize($this->getState('filter.frontaccess'));
		$id	.= ':'.serialize($this->getState('filter.frontdisplay'));
		$id	.= ':'.serialize($this->getState('filter.typefield'));
		$id	.= ':'.$this->getState('filter.editonlyfield');
		return parent::getStoreId($id);
	}
	
	protected function getListQuery() {
		$db		= $this->getDatabase();
		$query	= $db->createQuery();
		$query->select(
			$this->getState(
				'list.select',
				'a.*')
        )
            ->select([
                $db->quoteName('ag.title', 'access_level')
                ]);
		$query->from($db->qn('#__visfields') . ' AS a');

		$query->where($db->qn('a.fid') . ' = ' . $this->fid);
        $query->join('LEFT', $db->quoteName('#__viewlevels', 'ag'), $db->quoteName('ag.id') . ' = ' . $db->quoteName('a.frontaccess'));

		// filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where($db->qn('a.published') . ' = ' . (int) $published);
		}
		elseif ($published === '') {
			$query->where('('. $db->qn('a.published'). ' = 0 OR ' . $db->qn('a.published') . ' = 1)');
		}

		// filter by frontend display state
		$frontdisplay = $this->getState('filter.frontdisplay', []);
        if (!\is_array($frontdisplay)) {
            $frontdisplay = $frontdisplay ? [$frontdisplay] : [];
        }
        if (\count($frontdisplay)) {
            $frontdisplay       = ArrayHelper::toInteger($frontdisplay);
            // bindArray creates a prepared statement where every value of typefields has the proper type (is escaped properly); default is INTEGER
            $query->where($db->qn('a.frontdisplay') . ' IN (' . implode(',', $query->bindArray($frontdisplay)) . ')');
        }
        // Filter by access level.
        $access = $this->getState('filter.frontaccess');

        if (is_numeric($access)) {
            $access = (int) $access;
            $query->where($db->quoteName('a.frontaccess') . ' = :access')
                ->bind(':access', $access, ParameterType::INTEGER);
        } elseif (\is_array($access)) {
            $access = ArrayHelper::toInteger($access);
            $query->whereIn($db->quoteName('a.frontaccess'), $access);
        }
		// filter by field type
		$typefields = $this->getState('filter.typefield', []);
        if (!\is_array($typefields)) {
            $typefields = $typefields ? [$typefields] : [];
        }
        if (\count($typefields)) {
            // bindArray creates a prepared statement where every value of typefields has the proper type (is escaped properly); default is INTEGER
            $query->where($db->qn('a.typefield') . ' IN (' . implode(',', $query->bindArray($typefields, ParameterType::STRING)) . ')');
		}

		// filter by edit only fields
		$editonlyfield = $this->getState('filter.editonlyfield');
		if (is_numeric($editonlyfield)) {
			$query->where($db->qn('a.editonlyfield') . ' = ' . (int) $editonlyfield);
		}

        // filter by readonly value
        $readonly = $this->getState('filter.readonly');
        if (is_numeric($readonly)) {
            $operator = ((int) $readonly === 1) ? ' = ' . $db->q('1') : ' IS NULL';
            $query->where('JSON_EXTRACT('.$db->qn('a.defaultvalue').', CONCAT(\'$."\', \'f_\', '. $db->qn('a.typefield') .', \'_attribute_readonly"\'))'. $operator);
        }
        // filter by required value
        $required = $this->getState('filter.required');
        if (is_numeric($required)) {
            $operator = ((int) $required === 1) ? ' = ' . $db->q('1') : ' IS NULL';
            $query->where('JSON_EXTRACT('.$db->qn('a.defaultvalue').', CONCAT(\'$."\', \'f_\', '. $db->qn('a.typefield') .', \'_attribute_required"\')) '.$operator);
        }
        // filter by show label value
        $showlabel = $this->getState('filter.showlabel');
        if (is_numeric($showlabel)) {
            $query->where('JSON_EXTRACT('.$db->qn('a.defaultvalue').', CONCAT(\'$."\', \'f_\', '. $db->qn('a.typefield') .', \'_show_label"\')) = '. $db->q($showlabel));
        }
		// filter by search in label
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $db->Quote('%'.$db->escape($search, true).'%');
			$query->where('(' . $db->qn('a.label') . ' LIKE '.$search.' OR ' . $db->qn('a.name') . ' LIKE '.$search.')');
		}
		
		// add the list ordering clause
		$orderCol	= $this->state->get('list.ordering', 'a.id');
		$orderDirn	= $this->state->get('list.direction', 'asc');
		$query->order($db->escape($orderCol.' '.$orderDirn));
		return $query;
	}

	public function getItems() {
		$items = parent::getItems();
		if (empty($items)) {
			return $items;
		}
		foreach ($items as $i => $item) {
            if (in_array($item->typefield,  array('image', 'submit', 'fieldsep', 'reset', 'pagebreak', 'hidden'))) {
                $items[$i]->required = '-';
                $items[$i]->readonly = '-';
                $items[$i]->showlabel = '-';
                continue;
            }
            if (in_array($item->typefield,  array('calculation'))) {
                $items[$i]->required = '-';
                $items[$i]->readonly = '-';
                $propertyName = 'f_' . $item->typefield . '_show_label';
                $items[$i]->showlabel =(isset($defaultvalues[$propertyName]) ? ((empty($defaultvalues[$propertyName]) ? Text::_('JYES') : Text::_('JNO'))) :  '-');
                continue;
            }
			$defaultvalues = VisformsHelper::registryArrayFromString($item->defaultvalue);
			$propertyName = 'f_' . $item->typefield . '_attribute_required';
			$required = (isset($defaultvalues[$propertyName]) && !empty($defaultvalues[$propertyName])) ? Text::_('JYES') : Text::_('JNO');
			$items[$i]->required = $required;
            $propertyName = 'f_' . $item->typefield . '_attribute_readonly';
            $readonly = Text::_('JNO');
            if (isset($defaultvalues[$propertyName])&& !empty($defaultvalues[$propertyName])) {
                $readonly = Text::_('JYES') ;
            }
            $items[$i]->readonly = $readonly;
            $propertyName = 'f_' . $item->typefield . '_show_label';
            $showLabel = (isset($defaultvalues[$propertyName]) ? ((empty($defaultvalues[$propertyName]) ? Text::_('JYES') : Text::_('JNO'))) :  '-');
            $items[$i]->showlabel = $showLabel;
		}
		return $items;
	}

    public function getFid() {
		return $this->fid;
	}

    public function getFormtitle () {
        $db	= $this->getDatabase();
		$query = $db->createQuery();
        $query->select($db->quoteName('title'))
            ->from($db->quoteName('#__visforms'))
            ->where($db->qn('id') .' = '. $this->fid);
        try {
            $db->setQuery($query);
            $title = $db->loadResult();
            return $title;
        }
        catch (\RuntimeException $e) {
            return '';
        }
    }

    // Seems not to be used anywhere
    public function getSubmitFieldCount() {
        $db		= $this->getDatabase();
        $query	= $db->createQuery();
        $query->select($db->qn('id'))
            ->from($db->qn('#__visfields'))
            ->where($db->qn('typefield') . '=' . $db->q('submit'));
        try {
	        $db->setQuery($query);
            $result = $db->loadColumn();
            $count = count($result);
        }
        catch (\RuntimeException $e) {
            $count = 0;
        }
        return $count;
    }

    public function getFilterForm($data = array(), $loadData = true) {
        $form = parent::getFilterForm($data, $loadData);
        if (empty($form)) {
            return false;
        }
        $xml =
            '<field' . $this->getFilterFullOrderingFieldAttributes() . ' >
			<option value="">JGLOBAL_SORT_BY</option>
            <option value="a.ordering ASC">COM_VISFORMS_FIELD_ORDERING_FORM_ASC</option>
			<option value="a.ordering DESC">COM_VISFORMS_FIELD_ORDERING_FORM_DESC</option>
			<option value="a.published ASC">COM_VISFORMS_FIELD_ORDERING_STATUS_ASC</option>
			<option value="a.published DESC">COM_VISFORMS_FIELD_ORDERING_STATUS_DESC</option>
			<option value="a.label ASC">COM_VISFORMS_LABEL_ASC</option>
			<option value="a.label DESC">COM_VISFORMS_LABEL_DESC</option>
			<option value="a.id ASC">COM_VISFORMS_FIELD_ORDERING_ID_ASC</option>
			<option value="a.id DESC">COM_VISFORMS_FIELD_ORDERING_ID_DESC</option>
            <option value="a.typefield ASC">COM_VISFORMS_TYPEFIELD_ASC</option>
			<option value="a.typefield DESC">COM_VISFORMS_TYPEFIELD_DESC</option>
			<option value="a.frontdisplay ASC">COM_VISFORMS_FRONTDISPLAY_ASC</option>
			<option value="a.frontdisplay DESC">COM_VISFORMS_FRONTDISPLAY_DESCENDING</option>
			';
            if ($this->hasSub) {
                $xml .= '<option value="a.editonlyfield ASC">COM_VISFORMS_EDITONLYFIELD_ASC</option>';
                $xml .= '<option value="a.editonlyfield DESC">COM_VISFORMS_EDITONLYFIELD_DESC</option>';
                $xml .= '<option value="a.frontaccess ASC">COM_VISFORMS_FRONTEND_DATA_ACCESS_LEVEL_ASC</option>';
                $xml .= '<option value="a.frontaccess DESC">COM_VISFORMS_FRONTEND_DATA_ACCESS_LEVEL_DESC</option>';
                $xml .= '<option value="a.dataordering ASC">COM_VISFORMS_FRONTEND_DATA_ORDERING_ASC</option>';
                $xml .= '<option value="a.dataordering DESC">COM_VISFORMS_FRONTEND_DATA_ORDERING_DESC</option>';
            }

        $xml .= '</field>';
        $xmlField = new \SimpleXMLElement($xml);
        $form->setField($xmlField, 'list', 'true');
        // replaced filter field is always addded as last element
        // make sure, that limit list box stays as the last element, as is the standard in joomla
        // it is just confusing, if the limit list box is left of the order listbox.
        $xml = '<field
			name="limit"
			type="limitbox"
			class="js-select-submit-on-change"
			default="25"
			label="COM_VISFORMS_LIST_LIMIT"
			description="COM_VISFORMS_LIST_LIMIT_DESC"
				/>';
        $xmlField = new \SimpleXMLElement($xml);
        $form->setField($xmlField, 'list', 'true');
        return $form;
	}
}