<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class IpAddressEntry extends VisfieldPlaceholderEntry {

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_IPADDRESS_DIE'
    );

	public function __construct($param, $rawData, $field) {
		// call with $rawData = null, in order to get current user IP from $_SERVER
		if (is_null($rawData)) {
			$rawData = $_SERVER['REMOTE_ADDR'];
		}
		parent::__construct($param, $rawData, $field);
	}

	public function getReplaceValue() {
        if (!empty($this->param)) {
            if($this->param === 'DIE' && $this->hasSub && $this->rawData === '') {
                return 'die';
            }
            // return empty string to remove the placeholder
            return '';
        }
		return $this->rawData;
	}

}