<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
namespace Visolutions\Component\Visforms\Administrator\Visfield\PlaceholderEntry;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Administrator\Visfield\VisfieldPlaceholderEntry;

class SelectEntry extends VisfieldPlaceholderEntry {

	// display as list not yet supported because it is unclear how the returned html could look like
    protected static $customParams = array (
        'DISPLAYOPTIONLABEL' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_LABEL',
        'DISPLAYOPTIONLABELASLIST' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_LABEL_AS_LIST',
        'DISPLAYOPTIONVALUE' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_VALUE',
        'DISPLAYOPTIONVALUEASLIST' => 'COM_VISFORMS_PLACEHOLDER_PARAM_OPTION_VALUE_AS_LIST',
	);

    protected static $customSubscriptionParams = array (
        'DIE' => 'COM_VISFORMS_PLACEHOLDER_DIE'
    );

	public function getReplaceValue() {
		if (isset($this->rawData) && ($this->rawData === '')) {
            if (!empty($this->param) && $this->param === 'DIE' && $this->hasSub) {
                return 'die';
            }
            // return empty string to remove the placeholder
			return '';
		}
        $customParams = array_merge(self::$customParams, self::$labelParams, self::$customSubscriptionParams);
		if (!empty($this->param) && array_key_exists($this->param, $customParams)) {
			switch ($this->param) {
                case 'DIE' :
                    return '';
                case 'DISPLAYLABEL' :
                    return $this->field->label;
                case 'DISPLAYLABELPLUSSPACE' :
                    return $this->field->label . ' ';
				case 'DISPLAYOPTIONVALUE' :
					return HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
                case 'DISPLAYOPTIONVALUEASLIST' :
                    // Comma separated data string
                    $data = HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
                    $list = $this->getListHtml($data);
                    return $list;
                case 'DISPLAYOPTIONLABELASLIST' :
                    // Comma separated data string
                    $data = HTMLHelper::_('visformsselect.mapDbValueToOptionLabel', $this->rawData, $this->field->list_hidden);
                    $list = $this->getListHtml($data);
                    return $list;
                case 'DISPLAYOPTIONLABEL':
				default:
					return implode(', ', HTMLHelper::_('visformsselect.mapDbValueToOptionLabel', $this->rawData, $this->field->list_hidden));
			}
		}
		// legacy for old field option useoptionvalueinplaceholder
		else {
			if (!empty($this->field->useoptionvalueinplaceholder)) {
				return HTMLHelper::_('visformsselect.removeNullbyte', $this->rawData);
			}
		}
		// default return is file name
		return implode(', ', HTMLHelper::_('visformsselect.mapDbValueToOptionLabel', $this->rawData, $this->field->list_hidden));
	}

	protected function getListHtml($data) {
	    if (is_array($data) && !empty($data)) {
	        return implode('<br />', $data);
        }
	    else if (!empty($data)) {
	        return implode('<br />', explode(',', $data));
        }
        return '';
    }
}