<?php
/**
 * VisfieldBase class
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2024 vi-solutions
 * @since        Joomla 5.0
 */

namespace Visolutions\Component\Visforms\Administrator\Visfield;

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

class VisfieldBase {

    public $table;
    protected $property;
    protected $value;
    protected $hasSub;

    public function __construct($table, $property, $value) {
        $this->table = $table;
        $this->property = $property;
        $this->value = $value;
        $this->hasSub = AefHelper::checkAEF();
    }

    // if property is supported, set a value in the table object
    // return the table object
    public function setValue() {
        // Supported Properties: 'frontaccess', 'editonlyfield', 'frontdisplay', 'required' , 'readonly', 'showlabel'
        $property = $this->property;
        switch ($property) {
            case 'frontaccess':
                $this->setFrontaccess();
                break;
            case 'editonlyfield' :
                $this->setEditonlyfield();
                break;
            case 'frontdisplay' :
                $this->setFrontdisplay();
                break;
            case 'required' :
                $this->setRequired();
                break;
            case 'readonly' :
                $this->setReadonly();
                break;
            case 'showlabel' :
                $this->setShowlabel();
                break;
            default :
                break;
        }
        // return $this->table;
    }

    // Base Implementierung
    // Override in Field Type Class, if Field Type needs custom handling

    protected function setFrontaccess() {
        $value = $this->value;
        if (0 < $value) {
            $this->table->frontaccess = $value;
        }
    }

    protected function setEditonlyfield() {
        $value = $this->value;
        if ($value !== '') {
            if ($value == '1') {
                $restrictions = VisformsHelper::registryArrayFromString($this->table->restrictions);
                if (empty($restrictions)) {
                    $this->table->editonlyfield = $value;
                }
                else {
                    Factory::getApplication()->enqueueMessage(Text::sprintf('COM_VISFORMS_FIELD_BATCH_FIELD_EDIT_ONLY_HAS_RESTICTIONS', $this->table->id, 'warning'));
                }
            }
            else {
                $this->table->editonlyfield = $value;
            }
        }
    }

    protected function setFrontdisplay() {
        $value = $this->value;
        if ($value !== '') {
            $this->table->frontdisplay = $value;
        }
    }

    protected function setRequired() {
        $table = $this->table;
        $value = $this->value;
        if ($value !== '') {
            $defaultvalues = VisformsHelper::registryArrayFromString($table->defaultvalue);
            // required is checkbox. Unchecked = remove propery
            if ($value == '1') {
                $defaultvalues['f_' . $table->typefield . '_attribute_required'] = $value;
            }
            else {
                unset($defaultvalues['f_' . $table->typefield . '_attribute_required']);
            }
            $table->defaultvalue = VisformsHelper::registryStringFromArray($defaultvalues);
        }
    }

    protected function setReadonly() {
        $table = $this->table;
        $value = $this->value;
        if ($value !== '') {
            $defaultvalues = VisformsHelper::registryArrayFromString($table->defaultvalue);
            // required is checkbox. Unchecked = remove propery
            if ($value == '1') {
                $defaultvalues['f_' . $table->typefield . '_attribute_readonly'] = $value;
            }
            else {
                unset($defaultvalues['f_' . $table->typefield . '_attribute_readonly']);
            }
            $table->defaultvalue = VisformsHelper::registryStringFromArray($defaultvalues);
        }
    }

    protected function setShowlabel() {
        $table = $this->table;
        $value = $this->value;
        if ($value !== '') {
            $defaultvalues = VisformsHelper::registryArrayFromString($table->defaultvalue);
            $defaultvalues['f_' . $table->typefield . '_show_label'] = $value;
            $table->defaultvalue = VisformsHelper::registryStringFromArray($defaultvalues);
        }
    }
}