<?php
/**
 * Visforms view for Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 * @since        Joomla 3.6.2
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\FileLayout;

// used in fields table to provide drag & drop functionality if the browser supports "sortable". If not, native js is used to.
$wa = $this->getDocument()->getWebAssetManager();
$wa->registerAndUseScript('com_visforms.jquery.ui.core', 'media/com_visforms/js/jquery.ui.core.js', [], ['defer' => true])
    ->registerAndUseScript('com_visforms.jquery.ui.sortable', 'media/com_visforms/js/jquery.ui.sortable.js', [], ['defer' => true], ['com_visforms.jquery.ui.core']);

HTMLHelper::_('bootstrap.popover', '.hasPopover', array('trigger' => 'hover focus', 'placement' => 'top'));
$token = Session::getFormToken();
$fntext = 'Joomla\CMS\Language\Text::_';
$fnroute = 'Joomla\CMS\Router\Route::_';
$wa = $this->getDocument()->getWebAssetManager();

// custom form fields
$index                 = 0;
$customData           = array();
$customData[$index++] = array("reset", "reset", "reset");
$customData[$index++] = array("submit", "submit", "submit");
// contact form fields
$index                 = 0;
$contactData           = array();
$contactData[$index++] = array("text", "first", "first name");
$contactData[$index++] = array("text", "last", "last name");
$contactData[$index++] = array("text", "company", "company name");
$contactData[$index++] = array("text", "city", "city");
$contactData[$index++] = array("text", "postal", "postal code");
$contactData[$index++] = array("text", "country", "country");
$contactData[$index++] = array("text", "phone", "phone number");
$contactData[$index++] = array("email", "email", "email");
$contactData[$index++] = array("textarea", "message", "your message");
$contactData[$index++] = array("reset", "reset", "reset");
$contactData[$index++] = array("submit", "submit", "submit");
// registration form fields
$index                      = 0;
$registrationData           = array();
$registrationData[$index++] = array("text", "title", "title");
$registrationData[$index++] = array("text", "first", "first name");
$registrationData[$index++] = array("text", "last", "last name");
$registrationData[$index++] = array("text", "maiden", "maiden name");
$registrationData[$index++] = array("fieldsep", "fieldsep1", "fieldseparator");
$registrationData[$index++] = array("number", "age", "age");
$registrationData[$index++] = array("date", "birth", "birth date");
$registrationData[$index++] = array("multicheckbox", "gender", "gender");
$registrationData[$index++] = array("fieldsep", "fieldsep2", "fieldseparator");
$registrationData[$index++] = array("checkbox", "business", "company account");
$registrationData[$index++] = array("text", "company_first", "company owner first name");
$registrationData[$index++] = array("text", "company_last", "company owner last name");
$registrationData[$index++] = array("text", "company_name", "company name");
$registrationData[$index++] = array("text", "company_tax", "tax identification number");
$registrationData[$index++] = array("url", "company_web", "company web side");
$registrationData[$index++] = array("text", "company_position", "your position");
$registrationData[$index++] = array("fieldsep", "fieldsep3", "fieldseparator");
$registrationData[$index++] = array("text", "street", "street address");
$registrationData[$index++] = array("text", "street2", "street address line 2");
$registrationData[$index++] = array("text", "city", "city");
$registrationData[$index++] = array("text", "state", "state / province");
$registrationData[$index++] = array("text", "postal", "postal / zip code");
$registrationData[$index++] = array("text", "country", "country");
$registrationData[$index++] = array("fieldsep", "fieldsep4", "fieldseparator");
$registrationData[$index++] = array("text", "phone_area", "phone area code");
$registrationData[$index++] = array("text", "phone", "phone number");
$registrationData[$index++] = array("text", "mobil_area", "mobil area code");
$registrationData[$index++] = array("text", "mobil", "mobil number");
$registrationData[$index++] = array("email", "email", "email");
$registrationData[$index++] = array("url", "web", "web side");
$registrationData[$index++] = array("fieldsep", "fieldsep5", "fieldseparator");
$registrationData[$index++] = array("checkbox", "newsletter", "subscribe to newsletter");
$registrationData[$index++] = array("checkbox", "terms", "terms and conditions accepted");
$registrationData[$index++] = array("reset", "reset", "reset");
$registrationData[$index++] = array("submit", "submit", "submit");
// product form fields
$index                 = 0;
$productData           = array();
$productData[$index++] = array("text", "pid", "product id");
$productData[$index++] = array("text", "name", "name");
$productData[$index++] = array("textarea", "description", "description");
$productData[$index++] = array("number", "price", "price");
$productData[$index++] = array("number", "quantity", "quantity");
$productData[$index++] = array("reset", "reset", "reset");
$productData[$index++] = array("submit", "submit", "submit");
// all form field types
$index                 = 0;
$allData           = array();
$allData[$index++] = array("text", "text", "text");
$allData[$index++] = array("password", "password", "password");
$allData[$index++] = array("email", "email", "email");
$allData[$index++] = array("date", "date", "date");
$allData[$index++] = array("number", "number", "number");
$allData[$index++] = array("url", "url", "url");
$allData[$index++] = array("hidden", "hidden", "hidden");
$allData[$index++] = array("textarea", "textarea" , "textarea");
$allData[$index++] = array("checkbox", "checkbox", "checkbox");
$allData[$index++] = array("multicheckbox", "multicheckbox", "multicheckbox");
$allData[$index++] = array("radio", "radio", "radio");
$allData[$index++] = array("select", "select", "select");
$allData[$index++] = array("select", "gender", "gender");
$allData[$index++] = array("file", "fileupload", "fileupload");
$allData[$index++] = array("fieldsep", "fieldseparator", "fieldseparator");
$allData[$index++] = array("image", "image", "image");
$allData[$index++] = array("reset", "reset", "reset");
$allData[$index++] = array("submit", "submit", "submit");
// test form field types
/*$index                 = 0;
$testData           = array();
$testData[$index++] = array("text", "text", "text");
$testData[$index++] = array("email", "email", "email");
$testData[$index++] = array("date", "date", "date");
$testData[$index++] = array("checkbox", "checkbox", "checkbox");
$testData[$index++] = array("multicheckbox", "multicheckbox", "multicheckbox");
$testData[$index++] = array("radio", "radio", "radio");
$testData[$index++] = array("select", "select", "select");
$testData[$index++] = array("multicheckbox", "gender", "multicheckbox");
$testData[$index++] = array("radio", "gender", "radio");
$testData[$index++] = array("select", "sex", "select");
$testData[$index++] = array("submit", "submit", "submit");*/
// add field TDs
$addTdCheck    = '<label for="__char__cb0"><span class="visually-hidden">'.Text::_('JSELECT').' ' . Text::_('COM_VISFORMS_CREATOR_SINGLE_CB_CREATE_LABEL') . '</span></label><input id="__char__cb0" name="__char__cid[]" value="0" class="form-check-input" checked="" type="checkbox">';
$addTdName     = '<input name="" id="" value="" class="form-control inputbox required" size="50" placeholder="set name" maxlength="50" required="" aria-required="true" type="text">';
$addTdLabel    = '<input name="" id="" value="" class="form-control inputbox required" size="50" placeholder="set label" maxlength="50" required="" aria-required="true" type="text">';
$addTdFED      = '<label for="__char__fb0"><span class="visually-hidden">'.Text::_('JSELECT').' ' . Text::_('COM_VISFORMS_CREATOR_FIELD_FRONTEND_DISPLAY_DESCR') . '</span></label><input id="__char__fb0" name="__char__fid[]" value="0" class="form-check-input" type="checkbox">';
$addTdRequired = '<label for="__char__rb0"><span class="visually-hidden">'.Text::_('JSELECT').' ' . Text::_('COM_VISFORMS_CREATOR_REQUIRED_DESC') . '</span></label><input id="__char__rb0" name="__char__rid[]" value="0" class="form-check-input" type="checkbox">';
$addTdMove     = '<td class="hiddenSortable" style="text-align: center; vertical-align: middle;"><a href="#" class="up" title="move the field up"><span class="icon-arrow-up-4"/></a><a href="#" class="down" title="move the field down"><span class="icon-arrow-down-4"/></a></td>' . '<td class="hiddenNotSortable"><span class="itemMove"><i class="icon-menu" title="'. Text::_( "COM_VISFORMS_ITEMLISTCREATOR_MOVE_DRAG_AND_DROP", true ).'"></i></span></td>';
$addTdDelete   = '<td style="text-align: center; vertical-align: middle;"><a href="#" class="remove" title="remove the field"><span class="icon-delete"/></a></td>';
$js = <<<JS

    var fid = 0;
    var visHelper = {
        test: function (el) {
             //fid = 57;
            //this.createExampleData();
        },
        hidePopover: function (el) {
            if (el.parentElement.classList.contains('hasPopover')) {
            bootstrap.Popover.getInstance(el.parentElement).hide();
            }
        },
        dummy: function (event) {
            event.preventDefault();
        },
        createForm: function (event, tag, char) {
            this.createFormHelper(event, tag, char);
            bootstrap.Popover.getInstance(event.target).hide();
        },
        createFormHelper: function (event, tag, char) {
            // disable all 'create' buttons
            jQuery('.btn-create-form, .btn-add-field, .btn-submit-form, .btn-test-form').attr("disabled", "disabled");
            var parentId = 'vis-creator-' + tag;
            var checkedName = char + 'cid';
            var waitTag = tag;
            event.preventDefault();

            // form name and title
            var formTitle = this.testGroupInvalid('jform_title');
            var formName  = this.testGroupInvalid('jform_name');
            var invalid = '' == formTitle || '' == formName;

            // form fields
            var selected = jQuery('#' + parentId).find('input[name="' + checkedName + '\[\]"]:checked, input[name="xid\[\]"]:checked');
            var fields = [];
            for(var i = 0; i < selected.length; ++i) {
                var tr       = jQuery(selected[i]).parents('tr');
                var tdType   = jQuery(tr).find('td:nth-child(4) #jform_typefield');
                var type     = tdType.val();
                var name     = this.testInvalid(tr, 'td:nth-child(5) input');
                var label    = this.testInvalid(tr, 'td:nth-child(6) input');
                var fed      = jQuery(tr).find('td:nth-child(7) input').is(":checked");
                var required = jQuery(tr).find('td:nth-child(8) input').is(":checked");
                invalid = invalid || '' == name || '' == label || '' == type || '0' == type;
                fields.push({type: type, name: name, label: label, fed: fed, required: required});
                // red coloring for select type controls
                if('' == type || '0' == type) {
                    tdType.addClass('invalid');
                }
                else {
                    tdType.removeClass('invalid');
                }
            }

            // stay if something is missing
            if(invalid) {
                // enable all 'create' buttons
                jQuery('.btn-create-form, .btn-add-field, .btn-submit-form, .btn-test-form').removeAttr("disabled");
                return;
            }

            // form settings
            var saveresult = jQuery('#jform_saveresult').find('input:checked').val();
            var allowfedv  = jQuery('#jform_allowfedv').find('input:checked').val();
            var ownrecordsonly  = jQuery('#jform_ownrecordsonly').find('input:checked').val();
            // data to send
            var data = 'data=' + JSON.stringify({ fields: fields, name: formName, title : formTitle, saveresult: saveresult, allowfedv: allowfedv, ownrecordsonly: ownrecordsonly, "{$token}" : 1});
            // show the waiting icon during the request
            visHelperAsync.startWaitDonut('.icon_ajax-call-wait_' + waitTag);

            // send form data
            jQuery.ajax({
                type: 'POST',
                url: 'index.php?option=com_visforms&task=viscreator.createForm',
                data: data,
                success: function(data, textStatus, jqXHR) {
                    // hide the waiting icon
                    visHelperAsync.stopWaitDonut();
                    if (data.success) {
                        fid = data.fid;
                        // disable all controls
                        jQuery('#j-main-container input, #j-main-container select').prop('disabled', true);
                        // hide tab panels (field selection) for unused example forms
                        jQuery('#myTab joomla-tab-element').not("[active]").hide();
                        // show last panel (create data). Do not use .show()
                        // show() works differently from showing the tab by joomla tab element
                        // after show() panel is always visible
                        jQuery('#myTab joomla-tab-element').last().removeAttr('style');
                        // disable tabs for unused example forms
                        jQuery('#myTab button[role="tab"]').not("[aria-expanded='true']").prop('disabled', true);
                        // enable last tab (create data)
                        jQuery('#myTab button[role="tab"]').last().prop('disabled', false);
                        // disable all 'create' buttons
                        jQuery('.btn-create-form, .btn-add-field, .btn-submit-form, .btn-test-form').attr("disabled", "disabled");
                        // empty out all move and delete columns
                        var main = jQuery('#j-main-container');
                        // replace 'delete cross' with open link, remove inner html of td
                        jQuery(main).find('tr td:nth-last-child(1)').html('');
                        // enable 'go further' buttons
                        jQuery('#toolbar-file').find('button').removeAttr("disabled");
                        jQuery('#toolbar-forms').find('button').removeAttr("disabled");
                        jQuery('#toolbar-file-2').find('button').removeAttr("disabled");
                        jQuery('#toolbar-archive').find('button').removeAttr("disabled");
                        jQuery('#toolbar-home').find('button').removeAttr("disabled");
                        jQuery('#toolbar-user').find('button').removeAttr("disabled");
                        // enable generate example data
                        jQuery('#vis-creator-data input, #vis-creator-data select').removeAttr("disabled");
                        jQuery('#vis-creator-data').find('.btn-create-example-data').removeAttr("disabled");
                        // create 'open field' links
                        var tab = jQuery('#' + parentId);
                        // first and second column are 'move' columns
                        // remove them iterative
                        // 'move' with drag&drop
                        jQuery(tab).find('tr th:first-child').remove();
                        jQuery(tab).find('tr td:nth-child(1)').remove();
                        // second column (now first) 'move' with arrow up/down
                        jQuery(tab).find('tr th:first-child').remove();
                        jQuery(tab).find('tr td:nth-child(1)').remove();
                        // add new title 'open' and fill in field links to last column 'delete'
                        var title = '{$fntext('COM_VISFORMS_CREATOR_FIELD_TABLE_OPEN_DESC', true)}';
                        let openColumn =  jQuery(tab).find('tr th:nth-last-child(1)');
                        openColumn.text('{$fntext('COM_VISFORMS_CREATOR_FIELD_TABLE_OPEN', true)}');
                        // remove 'delete field' popover and set proper title attribute
                        openColumn.removeAttr("data-original-title");
                        openColumn.removeAttr("data-bs-content");
                        openColumn.attr("title", title);
                        // get the specific popover instance for this table header and remove text
                        let popover_instance = bootstrap.Popover.getInstance(document.querySelector('#' + parentId + ' .switchToOpenColumn'));
                        if (popover_instance) {
                            popover_instance._config.content = '';
                        }
                        jQuery(tab).find('tr td:nth-last-child(1)').each(function (index, value) {
                            if (typeof data.fields[index] !== 'undefined') {
                                var style = '';
                                var name = fields[index].name;
                                var type = fields[index].type;
                                if ('gender' !== name && 'sex' !== name) {
                                    if ('multicheckbox' === type || 'select' === type || 'radio' === type) {
                                        style = 'color: #FF5722;'
                                        title = '{$fntext('COM_VISFORMS_CREATOR_FIELD_TABLE_OPEN_SELECT_DESC', true)}';
                                    }
                                }
                                var onClick = "visHelper.openField(event, '" + data.fields[index] + "')";
                                jQuery(this).html('<a href="#" class="edit" title="' + title + '" onclick="' + onClick + '"><span class="icon-folder" style="' + style + '"/>');
                            }
                        });
                        visHelper.enableToolbarLinks();
                    }
                    // update side bar menus
                    if(data.sidebar) {
                        var html = jQuery(data.sidebar).html();
                        var sidebarOpen = jQuery('#j-sidebar-container').hasClass('j-sidebar-visible');
                        jQuery('#j-toggle-sidebar-wrapper ').html(html);
                        if (sidebarOpen) {
                            jQuery('#j-toggle-button-wrapper').addClass('j-toggle-visible');
                        }
                        else {
                            jQuery('#j-toggle-button-wrapper').addClass('j-toggle-hidden');
                            jQuery('#j-toggle-sidebar-icon').removeClass('j-toggle-visible icon-arrow-left-2').addClass('j-toggle-hidden icon-arrow-right-2');
                        }
                    }
                    // show success message
                    alert(data.message);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // hide the waiting icon
                    visHelperAsync.stopWaitDonut();
                    // enable all 'create' buttons
                    jQuery('.btn-create-form, .btn-add-field, .btn-submit-form, .btn-test-form').removeAttr("disabled");
                    // give error feedback
                    visHelper.showError(jqXHR.responseText, errorThrown);
                },
                dataType: 'json',
                async: true
            });
        },
        enableToolbarLinks : function() {
            jQuery("#toolbar-file").on("click", function(event) {event.preventDefault(); visHelper.navigate(1);}).removeClass('disabled');
            jQuery("#toolbar-list").on("click", function(event) {event.preventDefault(); visHelper.navigate(2);}).removeClass('disabled');
            jQuery("#toolbar-file-2").on("click", function(event) {event.preventDefault(); visHelper.navigate(3);}).removeClass('disabled');
            jQuery("#toolbar-archive").on("click", function(event) {event.preventDefault(); visHelper.navigate(4);}).removeClass('disabled');
            jQuery("#toolbar-home").on("click", function(event) {event.preventDefault(); visHelper.navigate(5);}).removeClass('disabled');
            jQuery("#toolbar-user").on("click", function(event) {event.preventDefault(); visHelper.navigate(6);}).removeClass('disabled');
            jQuery("#toolbar-screen").on("click", function(event) {event.preventDefault(); visHelper.test();})
        },
        testInvalid: function (tr, id) {
            var value  = jQuery(tr).find(id).val();
            if('' == value) {
                jQuery(tr).find(id).addClass('invalid');
            }
            else {
                jQuery(tr).find(id).removeClass('invalid');
            }
            return value;
        },
        testGroupInvalid: function (id) {
            var value  = jQuery('#' + id).val();
            if('' == value) {
                jQuery('#' + id).addClass('invalid');
                jQuery('#' + id + '-lbl').addClass('invalid');
            }
            else {
                jQuery('#' + id).removeClass('invalid');
                jQuery('#' + id + '-lbl').removeClass('invalid');
            }
            return value;
        },
        createExampleData: function (event) {
            if(null != event) {
                event.preventDefault();
            }
            var count = jQuery('#jform_count_example_data').val();

            // data to send
            var data = 'data=' + JSON.stringify({ fid: fid, count: count, "{$token}" : 1});

            // show the waiting icon during the request
            visHelperAsync.startWaitDonut('.icon_ajax-call-wait_data');

            // send form data
            jQuery.ajax({
                type: 'POST',
                url: 'index.php?option=com_visforms&task=viscreator.createExampleData',
                data: data,
                success: function(data, textStatus, jqXHR) {
                    // hide the waiting icon
                    visHelperAsync.stopWaitDonut();
                    alert(data.message);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // hide the waiting icon
                    visHelperAsync.stopWaitDonut();
                    // give error feedback
                    visHelper.showError(jqXHR.responseText, errorThrown);
                },
                dataType: 'json',
                async: true
            });
        },
        open: function (event, url) {
            event.preventDefault();
            window.open(url.replace('__fid__', fid));
        },
        openField: function (event, id) {
            event.preventDefault();
            var fieldUrl = '{$fntext("index.php?option=com_visforms&task=visfield.edit&layout=edit")}';
            var url = fieldUrl + '&id=' + id + '&fid=' + fid;
            url = url.replace(/&amp;/g, '&');
            window.open(url);
        },
        navigate: function (no) {
            var url = '';
            var openNewWindow = true;
            switch (no) {
                case 1:
                    url = '{$fnroute("index.php?option=com_visforms&task=visform.edit&id=__fid__")}';
                    break;
                case 2:
                    url = '{$fnroute("index.php?option=com_visforms&view=visfields&fid=__fid__")}';
                    break;
                case 3:
                    url = '{$fnroute("index.php?option=com_visforms&view=vispdfs&fid=__fid__")}';
                    break;
                case 4:
                    url = '{$fnroute("index.php?option=com_visforms&view=visdatas&fid=__fid__")}';
                    break;
                case 5:
                    url = '{$fnroute("index.php?option=com_menus&view=item&layout=edit&menutype=mainmenu")}';
                    break;
                case 6:
                    url = '{$fnroute("index.php?option=com_menus&view=item&client_id=0&menutype=usermenu&layout=edit")}';
                    break;
                case 7:
                    url = '{$fnroute("index.php?option=com_visforms&view=viscreator")}';
                    openNewWindow = false;
                    break;
            }
            url = url.replace(/&amp;/g, '&');
            url = url.replace('__fid__', fid);
            if(openNewWindow) {
                window.open(url);
            }
            else {
                location.href = url;
            }
        },
        showError: function (responseText, errorThrown) {
            var dlg = jQuery('#ajax-modal-error-dialog');
            if(responseText.startsWith('<!DOC')) {
                jQuery(dlg).find('.modal-body').html(errorThrown);
                jQuery(dlg).find('.modal-sub-title').html('');
            }
            else {
                jQuery(dlg).find('.modal-body').html(responseText);
                jQuery(dlg).find('.modal-sub-title').html('Text Status: ' + errorThrown);
            }
            jQuery(dlg).modal('show');
        }
    };
    var visTable = {
        tableAddSortableClass : function () {
            var sortableClass = (jQuery().sortable) ? 'ui-sortable' : 'notSortable';
            jQuery('[id*=table-creator]').addClass(sortableClass);
        },
        tableAddRow: function (event, tag, char) {
            // default would be: check for missing required values and point to the first one (including open fly by text: please fill this field)
            // may scroll the page back to the top after adding a new row in case of missing form title and long field list
            // the required check is done after a click on the 'create form and fields' button anyways
            event.preventDefault();
            // new row
            var row = jQuery('<tr>');
            // the columns: set check boxes identifier
            // this is a complete chosen listzbox, which we have to process later in order to work
            var tdSelect   = jQuery('#select-type-field');
            var clone = jQuery(tdSelect).clone();
            var tdCheck    = '{$addTdCheck}'.replace(/__char__/g, char);
            var tdName     = '{$addTdName}'.replace(/__char__/g, char);
            var tdLabel    = '{$addTdLabel}'.replace(/__char__/g, char);
            var tdFED      = '{$addTdFED}'.replace(/__char__/g, char);
            var tdRequired = '{$addTdRequired}'.replace(/__char__/g, char);
            // all append
            row.append(jQuery('{$addTdMove}'));
            row.append(jQuery('<td class="center">').html(tdCheck));
            row.append(jQuery('<td>').html(clone));
            row.append(jQuery('<td>').html(tdName));
            row.append(jQuery('<td>').html(tdLabel));
            row.append(jQuery('<td class="center hidden-phone">').html(tdFED));
            row.append(jQuery('<td class="center hidden-phone">').html(tdRequired));
            row.append(jQuery('{$addTdDelete}'));
            // new row right before the submit button row if any
            this.addRelativeToSubmit(row, tag);
            jQuery(row).find(".up,.down").click(function(event) {
                visTable.tableMoveRow(event, this);
            });
            bootstrap.Popover.getInstance(event.target).hide();
        },
        addRelativeToSubmit: function (row, tag) {
            // new row right before the submit button row if any
            tag = '#table-creator-' + tag;
            var rows = jQuery(tag + ' tbody tr');
            var found = false;
            jQuery.each(rows, function (index, tr) {
                var type = jQuery(tr).find('select').val();
                if('submit' === type || 'reset' === type) {
                    // a submit button was found: add new field before
                    jQuery(tr).before(row);
                    found = true;
                    return false;
                }
            });
            if( !found) {
                // no submit button was found: add new field at the end
                jQuery(tag + ' tbody tr:last').after(row);
            }
        },
        tableDeleteRow: function (event) {
            event.preventDefault();
            var elements = jQuery(event.target).parentsUntil('tbody');
            elements[elements.length-1].remove();
        },
        tableMoveRow: function(event, element) {
            event.preventDefault();
            var row = jQuery(element).parents("tr:first");
            if (jQuery(element).is(".up")) {
                row.insertBefore(row.prev());
            }
            else {
                row.insertAfter(row.next());
            }
        }
    };
    var visHelperAsync = {
        startWaitDonut: function (waitDonut) {
            jQuery(waitDonut).show();
        },
        stopWaitDonut: function (waitDonut) {
            if(null == waitDonut) {
                jQuery('.icon_ajax-call-wait').hide();
            }
            else {
                jQuery(waitDonut).hide();
            }
        }
    };
    jQuery(document).ready(function() {
        // todo: possibly freeze the field type selection for the first submit button
        // existing table order fields: attach up/down handler
        jQuery(".up,.down").click(function(event) {
            visTable.tableMoveRow(event, this);
        });
        jQuery('[name="jform[saveresult]"]').on('change', function(event){
           if (jQuery(event.target).val() == 1) {
              jQuery('button[aria-controls="vis-creator-data"]').show();
           }
           else {
              jQuery('button[aria-controls="vis-creator-data"]').hide();
           }
        });
        jQuery("#__char__cb0, #__char__fb0, #__char__rb0").on('click', function (event) {
            Joomla.isChecked(this.checked)
        })
        jQuery(".checkbox label.hasPopover").on('click', function(event) {visHelper.hidePopover(event.target);})
        jQuery("td .remove").on('click', function (event) {visTable.tableDeleteRow(event)});
        jQuery(".btn-create-example-data").on('click', function (event) {visHelper.createExampleData(event)});
        jQuery(".btn-create-form").on('click', function (event) {
            const tag = event.target.dataset.tag;
            const char = event.target.dataset.char;
            visHelper.createForm(event, tag, char);
        })
        jQuery('.btn-add-field').on('click', function(event) {
            const tag = event.target.dataset.tag;
            const char = event.target.dataset.char;
            visTable.tableAddRow(event, tag, char);
        })
        // disable 'go further' buttons on start, enable after form got created
        jQuery('#toolbar-file').addClass('disabled');
        jQuery('#toolbar-list').addClass('disabled');
        jQuery('#toolbar-forms').addClass('disabled');
        jQuery('#toolbar-file-2').addClass('disabled');
        jQuery('#toolbar-archive').addClass('disabled');
        jQuery('#toolbar-home').addClass('disabled');
        jQuery('#toolbar-user').addClass('disabled');
        jQuery("#toolbar-unpublish").on("click", function(event) {event.preventDefault(); visHelper.navigate(7);});
        // disable generate example data on start, enable after form got created
        jQuery('#vis-creator-data input, #vis-creator-data select').prop('disabled', true);
        visHelperAsync.stopWaitDonut();
        visTable.tableAddSortableClass();
        if (jQuery().sortable) {
            try {
                jQuery('[id*=table-creator]').sortable({
                    items: "tr",
                    cancel: "a,input,select",
                    addClasses: false,
                    tolerance: "pointer",
                    axis: "y",
                    containment: "parent",
                    helper: function (e, ui) {
                        //hard set left position to fix y-axis drag problem on Safari
                        jQuery(ui).css({'left':'0px'})

                        ui.children().each(function () {
                            jQuery(this).width(jQuery(this).width());
                        });
                        jQuery(ui).children('td').addClass('dndlist-dragged-row');
                        return ui;
                    },
                    start: function (event, ui) {
                        this.idx = ui.item.index();
                    },
                });
            }
            catch (e) {
            }
        }
    });
JS;

$wa->addInlineScript($js, ['name' => 'inline.viscreator'], ['type' => 'module']);

$css = <<<CSS
td .form-control {
    width: 100%;
}
CSS;
$wa->addInlineStyle($css);
?>
<!-- hidden pre defined templates repository  -->
<div id="templates" style="display: none">
    <div id="select-type-field"><?php echo $this->typefield->getCreatorInput(); ?></div>
</div>
<form id="adminForm" class="form-validate" action="<?php echo Route::_("$this->baseUrl&view=$this->editViewName&layout=edit&id=$this->id&fid=$this->fid"); ?>" method="post" name="adminForm">
    <div class="row"><?php
    if (!empty( $this->sidebar)) { ?>
        <div id="j-sidebar-container" class="col-md-3 col-xl-2">
        <?php echo $this->sidebar; ?>
        </div><?php } ?>
        <div class="<?php if (!empty($this->sidebar)) {echo 'col-md-9 col-xl-10'; } else { echo 'col-12'; } ?>">
            <div id="j-main-container" class="j-main-container">
            <div class="form-horizontal"><?php
                echo (new FileLayout('div.quickstart_help_element'))->render(array('step' => 1, 'description' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP1')); ?>
                <fieldset class="adminform"><?php
                    echo $this->form->renderField('title'); ?>
                </fieldset>
                <div class="row">
                    <div class="col-lg-12 col-xl-5">
                        <fieldset class="adminform"><?php
                            echo $this->form->renderField('name');
                            foreach ($this->form->getFieldset('form_basics') as $field) {
                                echo $field->renderField();
                            } ?>
                        </fieldset>
                    </div><?php
                    echo (new FileLayout('creator.warning'))->render(); ?>
                </div> <?php
                echo (new FileLayout('div.quickstart_help_element'))->render(array('step' => 2, 'description' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP2', 'hideTextStep' => true));
                echo HTMLHelper::_('uitab.startTabSet', 'myTab', array('active' => 'vis-creator-contact'));

                $tag = 'custom'; $char = 'a';
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-'.$tag, Text::_('COM_VISFORMS_CREATOR_CREATE_TAB_CUSTOM_FORM')); ?>
                <div class="row-fluid btns-create-form"> <?php
                    echo (new FileLayout('creator.create_buttons'))->render(array('tag' => $tag, 'char' => $char, 'text' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP3'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render($tag); ?>

                </div> <?php
                echo (new FileLayout('creator.fields_table'))->render(array('tag' => $tag, 'char' => $char, 'data' => $customData, 'form' => $this, 'tdMove' => $addTdMove, 'tdDelete' => $addTdDelete));
                echo HTMLHelper::_('uitab.endTab');

                $tag = 'contact'; $char = 'b';
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-'.$tag, Text::_('COM_VISFORMS_CREATOR_CREATE_TAB_CONTACT_FORM')); ?>
                <div class="row-fluid btns-create-form"><?php
                    echo (new FileLayout('creator.create_buttons'))->render(array('tag' => $tag, 'char' => $char, 'text' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP3V2'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render($tag); ?>
                </div> <?php
                echo (new FileLayout('creator.fields_table'))->render(array('tag' => $tag, 'char' => $char, 'data' => $contactData, 'form' => $this, 'tdMove' => $addTdMove, 'tdDelete' => $addTdDelete));
                echo HTMLHelper::_('uitab.endTab');

                $tag = 'login'; $char = 'c';
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-'.$tag, Text::_('COM_VISFORMS_CREATOR_CREATE_TAB_REGISTRATION_FORM')); ?>
                <div class="row-fluid btns-create-form"><?php
                    echo (new FileLayout('creator.create_buttons'))->render(array('tag' => $tag, 'char' => $char, 'text' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP3V2'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render($tag); ?>
                </div> <?php
                echo (new FileLayout('creator.fields_table'))->render(array('tag' => $tag, 'char' => $char, 'data' => $registrationData, 'form' => $this, 'tdMove' => $addTdMove, 'tdDelete' => $addTdDelete));
                echo HTMLHelper::_('uitab.endTab');

                $tag = 'product'; $char = 'd';
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-'.$tag, Text::_('COM_VISFORMS_CREATOR_CREATE_TAB_PRODUKT_FORM')); ?>
                <div class="row-fluid btns-create-form"><?php
                    echo (new FileLayout('creator.create_buttons'))->render(array('tag' => $tag, 'char' => $char, 'text' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP3V2'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render($tag); ?>
                </div> <?php
                echo (new FileLayout('creator.fields_table'))->render(array('tag' => $tag, 'char' => $char, 'data' => $productData, 'form' => $this, 'tdMove' => $addTdMove, 'tdDelete' => $addTdDelete));
                echo HTMLHelper::_('uitab.endTab');

                $tag = 'all'; $char = 'e';
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-'.$tag, Text::_('COM_VISFORMS_CREATOR_CREATE_TAB_ALL_FIELD_TYPES_FORM')); ?>
                <div class="row-fluid btns-create-form"> <?php
                    echo (new FileLayout('creator.create_buttons'))->render(array('tag' => $tag, 'char' => $char, 'text' => 'COM_VISFORMS_CREATOR_QUICKSTART_STEP3V2'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render($tag); ?>
                </div> <?php
                echo (new FileLayout('creator.fields_table'))->render(array('tag' => $tag, 'char' => $char, 'data' => $allData, 'form' => $this, 'tdMove' => $addTdMove, 'tdDelete' => $addTdDelete));
                echo HTMLHelper::_('uitab.endTab');
                $step =  (new FileLayout('div.quickstart_help_element'))->render(array('step' => 5, 'hideTextStep' => true, 'tag' => 'span'));
                echo HTMLHelper::_('uitab.addTab', 'myTab', 'vis-creator-data', $step . ' ' . Text::_('COM_VISFORMS_CREATOR_TAB_GENERATE_EXAMPLE_DATA_LABEL')); ?>
                <div class="row-fluid btns-create-form">
                    <button data-bs-content="<?php echo Text::_('COM_VISFORMS_CREATOR_CREATE_DATA'); ?>" class="btn btn-small btn-info btn-create-example-data hasPopover" disabled><?php echo Text::_('COM_VISFORMS_CREATOR_CREATE_DATA'); ?></button>
                   <?php echo (new FileLayout('div.quickstart_help_element'))->render(array('step' => 6, 'description' => 'COM_VISFORMS_CREATOR_CREATE_DATA_DESCR', 'hideTextStep' => true, 'tag' => 'span'));
                    echo (new FileLayout('div.icon_ajax_call_wait'))->render('data'); ?>
                </div>
                <fieldset class="adminform"><?php
                    $field = $this->form->getField('count-example-data');
                    echo $field->renderField(); ?>
                </fieldset> <?php
                echo HTMLHelper::_('uitab.endTab');

                echo HTMLHelper::_('uitab.endTabSet'); ?>
            </div><?php
            $layout = new FileLayout('div.form_hidden_inputs');
            echo $layout->render(); ?>
        </div><?php
        // ajax modal error dialog
        echo (new FileLayout('div.ajax_modal_error_dialog'))->render(); ?>
        </div>
    </div>
</form>
