<?php
/**
 * Visforms
 *
 * @author       Ingmar Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 * @since        Joomla 3.0.0
 */

defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Database\DatabaseInterface;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

$hasSub =  AefHelper::checkAEF();

?>
<div class="container">

    <div class="row">
        <div class="form-group col-md-6">
            <div class="controls"> <?php
                $fid = Factory::getApplication()->getInput()->getInt( 'fid', 0 );
                // create copy select options
                $db = Factory::getContainer()->get(DatabaseInterface::class);
                $query = $db->createQuery();
                $query->select('a.id, a.title');
                $query->from('#__visforms AS a');
                try {
                    $db->setQuery($query);
                    $forms = $db->loadObjectList();
                }
                catch (RuntimeException $e) {
                    $forms = false;
                }
                $options = array();
                foreach ($forms as &$form){
                    $options[] = HTMLHelper::_('select.option', $form->id, $form->title);
                }
                // Create the batch forms listbox, default selected value the form, the fields belong to.
                ?>
                <label id="batch-choose-action-lbl" for="batch-choose-action"><?php echo Text::_('COM_VISFORMS_COPY_TO_FORM'); ?></label>
                <fieldset id="batch-choose-action" class="combo">
                    <select name="batch[form_id]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_COPY_TO_FORM') . '::' . Text::_('COM_VISFORMS_COPY_TO_FORM_DESC'); ?>" id="batch-form-id">
                        <?php
                        // with sub, allow empty option, in order to enable fastswitch batch functions
                        if ($hasSub) { ?>
                        <option value=""><?php echo Text::_('COM_VISFORMS_COPY_TO_FORM_NO_FORM'); ?></option>
                        <?php echo HTMLHelper::_('select.options', $options, 'value', 'text', ''); ?>
                        <?php }
                        else {
                            echo HTMLHelper::_('select.options', $options, 'value', 'text', $fid);
                        }?>
                    </select>
                </fieldset>
            </div>
        </div>
        <?php if ($hasSub) { ?>
        <div class="col-md-6">
            <div class="controls">
                <?php echo LayoutHelper::render('joomla.html.batch.access', []); ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="form-group col-md-6">
            <div class="controls">
                <label id="batch-choose-frontenddisplay-lbl" for="batch-choose-frontenddisplay"><?php echo Text::_('COM_VISFORMS_BATCH_FRONTEND_DISPLAY'); ?></label>
                <fieldset id="batch-choose-frontenddisplay" class="combo">
                    <select name="batch[frontenddisplay]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_BATCH_FRONTEND_DISPLAY') . '::' . Text::_('COM_VISFORMS_BATCH_FRONTEND_DISPLAY'); ?>" id="batch-frontenddisplay">
                    <option value=""><?php echo Text::_('COM_VISFORMS_BATCH_NO_CHANGE'); ?></option>
                        <option value="0"><?php echo Text::_('COM_VISFORMS_FIELD_FRONTDISPLAY_NONE'); ?></option>
                        <option value="1"><?php echo Text::_('COM_VISFORMS_FIELD_FRONTDISPLAY_BOTH'); ?></option>
                        <option value="2"><?php echo Text::_('COM_VISFORMS_FIELD_FRONTDISPLAY_LIST_ONLY'); ?></option>
                        <option value="3"><?php echo Text::_('COM_VISFORMS_FIELD_FRONTDISPLAY_DETAIL_ONLY'); ?></option>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="col-md-6">
            <div class="controls">
                <label id="batch-choose-editonlyfield-lbl" for="batch-choose-editonlyfield"><?php echo Text::_('COM_VISFORMS_BATCH_IS_EDIT_ONLY_FIELD_LABEL'); ?></label>
                <fieldset id="batch-choose-editonlyfield" class="combo">
                    <select name="batch[editonlyfield]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_BATCH_IS_EDIT_ONLY_FIELD_LABEL') . '::' . Text::_('COM_VISFORMS_BATCH_IS_EDIT_ONLY_FIELD_LABEL'); ?>" id="batch-editonlyfield">
                        <option value=""><?php echo Text::_('COM_VISFORMS_BATCH_NO_CHANGE'); ?></option>
                        <option value="0"><?php echo Text::_('JNO'); ?></option>
                        <option value="1"><?php echo Text::_('JYES'); ?></option>
                    </select>

                </fieldset>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="form-group col-md-6">
            <div class="controls">
                <label id="batch-choose-required-lbl" for="batch-choose-required"><?php echo Text::_('COM_VISFORMS_BATCH_REQUIRED'); ?></label>
                <fieldset id="batch-choose-required" class="combo">
                    <select name="batch[required]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_BATCH_REQUIRED') . '::' . Text::_('COM_VISFORMS_BATCH_REQUIRED'); ?>" id="batch-required">
                        <option value=""><?php echo Text::_('COM_VISFORMS_BATCH_NO_CHANGE'); ?></option>
                        <option value="0"><?php echo Text::_('JNO'); ?></option>
                        <option value="1"><?php echo Text::_('JYES'); ?></option>
                    </select>
                </fieldset>
            </div>
        </div>
        <div class="col-md-6">
            <div class="controls">
                <label id="batch-choose-readonly-lbl" for="batch-choose-readonly"><?php echo Text::_('COM_VISFORMS_BATCH_READONLY'); ?></label>
                <fieldset id="batch-choose-readonly" class="combo">
                    <select name="batch[readonly]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_BATCH_READONLY') . '::' . Text::_('COM_VISFORMS_BATCH_READONLY'); ?>" id="batch-readonly">
                        <option value=""><?php echo Text::_('COM_VISFORMS_BATCH_NO_CHANGE'); ?></option>
                        <option value="0"><?php echo Text::_('JNO'); ?></option>
                        <option value="1"><?php echo Text::_('JYES'); ?></option>
                    </select>

                </fieldset>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="form-group col-md-6">
            <div class="controls">
                <label id="batch-choose-showlabel-lbl" for="batch-choose-showlabel"><?php echo Text::_('COM_VISFORMS_BATCH_SHOW_LABEL'); ?></label>
                <fieldset id="batch-choose-showlabel" class="combo">
                    <select name="batch[showlabel]" class="custom-select" title="<?php echo Text::_('COM_VISFORMS_BATCH_SHOW_LABEL') . '::' . Text::_('COM_VISFORMS_BATCH_SHOW_LABEL'); ?>" id="batch-showlabel">
                        <?php // 0 = Show, 1 = hide! ?>
                        <option value=""><?php echo Text::_('COM_VISFORMS_BATCH_NO_CHANGE'); ?></option>
                        <option value="1"><?php echo Text::_('JNO'); ?></option>
                        <option value="0"><?php echo Text::_('JYES'); ?></option>
                    </select>
                </fieldset>
            </div>
        </div>
    </div>
    <?php } ?>
</div>