<?php
/**
 * Visforms control html for pagebreak button for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;

if (!empty($displayData)) :
	if (isset($displayData['field'])) :
		$field = $displayData['field'];
		$mpDisplayType = $field->mpdisplaytype;
		// 0 is multi page, 1 = accordion
		if (!empty($mpDisplayType) && ($mpDisplayType == 1)) :
			$firstPanelCollapsed = $field->firstpanelcollapsed;
			$html = array();
			$accordionid = (!empty($field->accordionid)) ? $field->accordionid : 'visformaccordion';
			$collapseid = 'collapse' . $field->id;
			$panelState = ((!empty($field->accordioncounter)) && ($field->accordioncounter == 1) && empty($firstPanelCollapsed)) ? 'show' : '';
			$ariaPanelState =  ((!empty($field->accordioncounter)) && ($field->accordioncounter == 1) && empty($firstPanelCollapsed)) ? ' aria-expanded="true"' : ' aria-expanded="false"';
            $headerId = $accordionid . '-header' . $field->accordioncounter;
			if ((!empty($field->accordioncounter)) && ($field->accordioncounter > 1)) {
				// close last row-fluid from previous accordion
				$html[] = '</div>';
				//close previous accordion
				$html[] = '</div>';
				$html[] = '</div>';
				$html[] = '</div>';
			}
			else if ($field->accordioncounter == 1) {
				// close last div class="row" from view file which may contain fields that are placed before the first accordion
				$html[] = '</div>';
				// open accordion container
				$html[] = '<div class="accordion mb-3" id="' . $accordionid . '">';
			}
			$html[] = '<div class="accordion-group card">';
			$html[] = '<div class="accordion-heading card-header">';
			$html[] = '<h4 class="" id="'.$headerId.'"><a class="accordion-toggle" data-bs-toggle="collapse" data-bs-target="#'.$collapseid.'" aria-controls="' . $collapseid . '"' . $ariaPanelState . ' role="button" tabindex="0">'.$field->label.'</a></h4>';
			$html[] = '</div>';
			$html[] = '<div id="' . $collapseid . '" class="accordion-body collapse ' . $panelState . '" data-bs-parent="#'.$accordionid.'" aria-labelledby="'.$headerId.'">';
			$html[] = '<div class="accordion-inner card-body">';
			$html[] = '<div class="row">';
			echo implode('', $html);
		else :
            $step = (!empty($field->fieldsetcounter)) ? $field->fieldsetcounter : 0;
            $backButtonText = (!empty($field->backbtntext)) ? $field->backbtntext : Text::_('COM_VISFORMS_STEP_BACK');
            $backBtnClass = (!empty($field->backbtncssclass)) ? 'btn back_btn ' . $field->backbtncssclass : 'btn back_btn ';
            $nextBtnClass = '';
            $nextBtnText = Text::_('COM_VISFORMS_STEP_NEXT');
            $mpfButtonPosition = (!empty($field->mpfbuttonposition)) ? $field->mpfbuttonposition : '';
            if (!empty($field->attributeArray)) {
                if (isset($field->attributeArray['class'])) {
                    $nextBtnClass =  $field->attributeArray['class'];
                }
                if (isset($field->attributeArray['value'])){
                    $nextBtnText = $field->attributeArray['value'];
                }
            }
            echo LayoutHelper::render('visforms.footers.bt5.mpfnavigation', array('addResetAncor' => false, 'nextBtnClass' => $nextBtnClass, 'nextBtnText' => $nextBtnText, 'backBtnText' => $backButtonText, 'backBtnClass' => $backBtnClass, 'step' => $step, 'mpfButtonPosition' => $mpfButtonPosition), null, array('component' => 'com_visforms'));
		endif;
	endif;
endif;