<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Recaptcha\Recaptcha;
use Joomla\CMS\Layout\LayoutHelper;

if (!empty($displayData)) :
	if (isset($displayData['form'])) :
        $form = $displayData['form'];
        $captcha = New Recaptcha($form);
	    if ($captcha->isEnabled()) :
            $input = $captcha->render();
            $html = array();
            $name = 'g-recaptcha-response';
            $errorDivClass = 'fc-tbx' . $name . '_field';
            $captchaInputBtClasses = $form->captchaInputBtClasses;
            $indentedBtClasses = $form->indentedBtClasses;
            if (isset($form->captcha) && (int) $form->captcha === 4) {
                $html[] = '<div class="form-group row required">';
                $html[] = LayoutHelper::render('visforms.captcha.bt5.label', array('form' => $form, 'name' => $name), null, array('component' => 'com_visforms'));
                $html[] = '<div class="' . $captchaInputBtClasses . '">';
                if (!empty($form->captchacustominfo)) {
                    $html[] = '<div class="visToolTip" title="' . htmlspecialchars($form->captchacustominfo, ENT_COMPAT, 'UTF-8') . '" data-bs-toogle>';
                }
                $html[] = $input;
                if (!empty($form->captchacustominfo)) {
                    $html[] = '</div>';
                }
                $html[] = '</div>';
                $html[] = '</div>';
                // Create a div with the right class where we can put the validation errors into
                $html[] = '<div class="' . $indentedBtClasses . '">';
                $html[] = '<div class="' . $errorDivClass . '"></div>';
                $html[] = '</div>';
                if (!empty($form->captchacustominfo)) {
                    HTMLHelper::_('visforms.visformsTooltip');
                }
            }
            echo implode('', $html);
        endif;
	endif;
endif;