<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\VisformsHelper;

if (!empty($displayData) && isset($displayData['recordId']) && isset($displayData['detailTemplates']) && isset($displayData['pdfTemplates']) && isset($displayData['form'])) {
    $recordId = $displayData['recordId'];
    $detailTemplates = $displayData['detailTemplates'];
    $pdfTemplates = $displayData['pdfTemplates'];
    $form = $displayData['form'];
    $options = array();
    foreach ($detailTemplates as $id => $display) {
        // display is an array with a list of all items for which the user can download this pdf (so it may be empty)
        if ($display && in_array($recordId, $display)) {
            $pdfDownloadlinkText = (!empty($text = VisformsHelper::getPdfDownlaodLinkTitle($id, $pdfTemplates))) ? Text::sprintf('COM_VISFORMS_DOWNLOAD_AS_PDF_TEXT_FOR_NAMED_DOCUMENT', $text) : Text::_('COM_VISFORMS_DOWNLOAD_PDF');
            $options[] = '<option value="renderPdf_' . $id . '">' . $pdfDownloadlinkText . '</option>';
        }
    }
    if (!empty($options)) {
        HTMLHelper::_('visforms.loadDataTaskJs');
        $emptyOption = '<option value="" selected="selected">' . Text::_('COM_VISFORMS_SELECT_LIST_DOWNLOAD_DOCUMENT') . '</option>';
        $options = implode('', $options);
        $label = '<label for="select-list-pdf-download-detail" class="visually-hidden sr-only uk-invisible select-list-pdf-download-lbl">' . Text::_('COM_VISFORMS_SELECT_LIST_DOWNLOAD_DOCUMENT_LABEL') . '</label>';
        $list = $label . '<select name="select-list-pdf-download-detail" class="form-select select-list-pdf-download" data-form-id="'.$form->id.'" data-list-base-url="'. Uri::base().'">' . $emptyOption . $options . '</select>';
        echo $list;
    }
}