<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2018 vi-solutions
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;
use Visolutions\Component\Visforms\Administrator\Helper\MediaHelper;

if (!empty($displayData) && isset($displayData['text']) && isset($displayData['field'])) {
    $hasSub = AefHelper::checkAEF();
	$field = $displayData['field'];
	// $text is JSON with directory path (folder)  and file name (file)
	$text = $displayData['text'];
	$viewType = (!empty($displayData['viewType'])) ? $displayData['viewType'] : 'row';
	$htmlTag = (!empty($displayData['htmlTag'])) ? $displayData['htmlTag'] : 'td';
	$class = (!empty($displayData['class'])) ? ' class="' . $displayData['class'] . '"' : '';
	$showLink = (isset($field->showlink) && !empty($field->showlink)) ? true : false;
	$isImage = MediaHelper::isImage(HTMLHelper::_('visforms.getUploadFileName', $text));
	$showAsImage = (($viewType === 'row' && !empty($field->displayImgAsImgInDetail)) || ($viewType === 'column' && !empty($field->displayImgAsImgInList))) ? true : false;
	// property not set, if no subscription, default to 0
	$textLinkType = (isset($field->link_text_type) && $hasSub) ? $field->link_text_type : 0;
	$fileLinkCustomText = (!empty($displayData['fileLinkCustomText'])) ? $displayData['fileLinkCustomText'] : '';
	if (!empty($showAsImage) && $isImage) {
		$text = '<img src="' .Uri::root(true) . '/' . HTMLHelper::_('visforms.getUploadFilePath', $text) . '" alt="" role="presentation"/>';
	}
	else if (empty($text) || !$showLink) {
		$text = HTMLHelper::_('visforms.getUploadFileName', $text);
		$text = basename($text);
	}
	else{
		$text = HTMLHelper::_('visforms.getUploadFileLink', $text, $textLinkType, $fileLinkCustomText);
	}
    echo '<' . $htmlTag . $class . '>' . $text . '</' . $htmlTag . '>';
}