<?php
/**
 * Visforms control html for pagebreak button for default layout
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\Language\Text;

if (!empty($displayData)) :
	    $addResetAncor = (!empty($displayData['addResetAncor'])) ? 'reset-ancor text-center': '';
        $nextBtnClass = (!empty($displayData['nextBtnClass'])) ? $displayData['nextBtnClass']: Text::_('COM_VISFORMS_STEP_NEXT');
        $nextBtnText = (!empty($displayData['nextBtnText'])) ? $displayData['nextBtnText']: '';
        $showNextButton = (!empty($displayData['hideNextButton'])) ? false : true;
        $backButtonText = (!empty($displayData['backBtnText'])) ? $displayData['backBtnText'] : Text::_('COM_VISFORMS_STEP_BACK');
        $backBtnClass = (!empty($displayData['backBtnClass'])) ? 'btn back_btn ' . $displayData['backBtnClass'] : 'btn back_btn ';
        $isSummaryPage = (!empty($displayData['isSummaryPage'])) ? true : false;
        $step = (!empty($displayData['step'])) ? (int) $displayData['step'] : 0;
        $actionControls = (!empty($displayData['actionControls'])) ? $displayData['actionControls'] : '';
        $mpfButtonPosition = (!empty($displayData['mpfButtonPosition'])) ? $displayData['mpfButtonPosition'] : '';
        $html = array();
        if (empty($mpfButtonPosition)) {
            // new special layout
            // Display back/next icon left and right as icons and all other buttons centered
            $html[] = '<div class="col-12">';
            $html[] = '<div class="form-group row justify-content-between pbBtnCon">';
            $html[] = '<div class="col-1">';
            if ($step > 1 || $isSummaryPage) {
                // add a back button
                $html[] = '<button type="button" class="' . $backBtnClass . '" title="' . $backButtonText . '">';
                $html[] = '<span class="visicon-chevron-left" aria-hidden="true"></span><span class="visually-hidden">' . $backButtonText . '</span></button>';
            }
            $html[] = '</div>';
            $html[] = '<div class="col-10 '.$addResetAncor.'">'.$actionControls.'</div>';
            $html[] = '<div class="col-1 text-end">';
            if ($showNextButton) {
                $html[] = '<button type="button" class="' . $nextBtnClass . '" title="' . $nextBtnText . '">';
                $html[] = '<span class="visicon-chevron-right" aria-hidden="true"></span><span class="visually-hidden">' . $nextBtnText . '</span></button>';
            }
            $html[] = '</div>';
            $html[] = '</div>';
            $html[] = '</div>';
        }
        else {
            // display buttons according to form configuration setting
            switch ($mpfButtonPosition) {
                case 'left' :
                    $buttonDisplayDirection = 'justify-content-start';
                    break;
                case 'right' :
                    $buttonDisplayDirection = 'justify-content-end';
                    break;
                default:
                    $buttonDisplayDirection = 'justify-content-center';
            }
            $html[] = '<div class="col-12">';
            $html[] = '<div class="form-group row ' . $buttonDisplayDirection . ' pbBtnCon">';
            if ($step > 1 || $isSummaryPage) {
                $html[] = '<div class="col-auto">';
                    // add a back button
                    $html[] = '<input type="button" class="' . $backBtnClass . '" value="' . $backButtonText . '" title="' . $backButtonText . '"/>';

                $html[] = '</div>';
            }
            if (!empty($addResetAncor) || !empty($actionControls)) {
                $html[] = '<div class="col-auto ' . $addResetAncor . '">';
                $html[] = $actionControls;
                $html[] = '</div>';
            }
            if ($showNextButton) {
                $html[] = '<div class="col-auto">';
                $html[] = '<input type="button" class="' . $nextBtnClass . '" value="' . $nextBtnText . '" title="' . $nextBtnText . '"/>';
                $html[] = '</div>';
            }
            $html[] = '</div>';
            $html[] = '</div>';
        }
        echo implode('', $html);
endif;