<?php
/**
 * Visforms decorator class for HTML controls
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/* @deprecated 5.5 will be removed in Visforms 6.0
 *              Use \Visolutions\Component\Visforms\Site\Lib\Html\Control\ControlAwareTrait and
 *              the class \Visolutions\Component\Visforms\Site\Lib\Html\Control\Control instead
 */
abstract class VisformsHtmlControl
{
	public static function getInstance($field, $layout) {
        $fieldType = $field->typefield;
        switch ($layout) {
            case 'visforms' :
                $prefix = 'None';
                break;
            case 'edit' :
                $prefix = 'NoneEdit';
                break;
            case 'editbt5' :
                $prefix = 'Bt5Edit';
                break;
            case 'edituikit3' :
                $prefix = 'Uikit3Edit';
                break;
            default:
                $prefix = ucfirst($layout);
        }
        $nameSpace = '\Visolutions\Component\Visforms\Site\Lib\Html\Control\\';
        $className = $nameSpace . $prefix . ucfirst($fieldType).'Control';
        // delegate to the appropriate class
        return new $className($field, $layout);
    }
}