<?php
/**
 * VisformsBaseFormPrepare Event for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.0.0
 */

namespace Visolutions\Component\Visforms\Site\Event\Visforms;
// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\Registry\Registry;
use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsAbstractEvent;

class VisformsBaseFormPrepareEvent extends VisformsAbstractEvent{

    public function __construct($name, array $arguments = []) {
        parent::__construct($name, $arguments);

        if (!\array_key_exists('subject', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'subject' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('menuparams', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'menuparams' of event {$name} is required but has not been provided");
        }
        if (!\array_key_exists('context', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'context' of event {$name} is required but has not been provided");
        }
    }

    public function getForm(): object  {
        return $this->arguments['subject'];
    }

    public function getMenuParams(): Registry  {
        return $this->arguments['menuparams'];
    }

    public function getContext(): string {
        return $this->arguments['context'];
    }

}