<?php
/**
 * VisformsBaseHtmlPrepare Event for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 5.0.0
 */

namespace Visolutions\Component\Visforms\Site\Event\Visforms;
// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Visolutions\Component\Visforms\Administrator\Event\Visforms\VisformsAbstractEvent;

class VisformsBaseHtmlPrepareEvent extends VisformsAbstractEvent{

    public function __construct($name, array $arguments = []) {
        parent::__construct($name, $arguments);

        if (!\array_key_exists('field', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'field' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('context', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'context' of event {$name} is required but has not been provided");
        }

        if (!\array_key_exists('layout', $this->arguments)) {
            throw new \BadMethodCallException("Argument 'layout' of event {$name} is required but has not been provided");
        }
    }

    public function getField(): object  {
        return $this->arguments['field'];
    }

    public function getContext(): string {
        return $this->arguments['context'];
    }
    public function getLayout(): string {
        return $this->arguments['layout'];
    }

}