<?php
/**
 * Visforms field email business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Visolutions\Component\Visforms\Site\Lib\Message\MailExistsMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\VerificationCodeValidation;

class EmailFieldBusiness extends TextFieldBusiness
{

	protected function setField() {
		$this->setIsDisabled();
		$this->setCustomJs();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post')
		{
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}
	
    protected function setCustomJs() {
    	if ((!isset($this->field->validate_mailExists)) && (empty($this->field->toggle_value_from_sql))) {
    		return;
	    }
	    $field = $this->field;
        if (isset($this->field->validate_mailExists)) {
            $extraAttribs = ' placeholder=\"' . Text::_('COM_VISFORMS_ENTER_VERIFICATION_CODE_PLACEHOLDER') . '\"';
            $extraAttribs .= (!empty($field->attribute_value)) ? ' required = \"required\" aria-required=\"true\" ' : '';
            $extraAttribs .= (isset($field->isDisabled) && ($field->isDisabled == true)) ? ' disabled=\"disabled\"' : '';
            $extraAttribs .= ' data-error-container-id=\"fc-tbxfield' . $field->id . '_code\"';
            $extraClass = (isset($field->isDisabled) && ($field->isDisabled == true)) ? ' ignore' : '';
            // There is no email exists validation in edit views!
            switch ($this->form->formlayout) {
                case 'uikit3' :
                    $script = '
			        jQuery(document).ready( function() {	        
				        jQuery("<div class=\"fc-tbxfield' . $field->id . '_code\"></div><span class=\"uk-button uk-button-default uk-width-1-3@l uk-width-1-1@s verifyMailBtn\" data-fieldid=\"field' . $field->id . '\" data-fid=\"' . $field->fid . '\" data-token=\"' . Session::getFormToken() . '\" data-baseurl=\"' . Uri::base(true) . '\">' . Text::_('COM_VISFORMS_VERIFY') . '</span><input type=\"text\" id=\"field' . $field->id . '_code\" name=\"' . $field->name . '_code\" class=\" uk-input uk-width-2-3@l uk-width-1-1@s verificationCode' . $extraClass . '\"' . $extraAttribs . ' />").insertAfter("#field' . $field->id . '");
				        ' . $this->getDefaultScript('uk-button-primary', 'uk-button-default') . '
			        });
			    ';
                    break;
                default :
                    $script = '
			        jQuery(document).ready( function() {	  	             
				        jQuery("<div class=\"fc-tbxfield' . $field->id . '_code\"></div><span class=\"btn verifyMailBtn visCSSlabel\" data-fieldid=\"field' . $field->id . '\" data-fid=\"' . $field->fid . '\" data-token=\"' . Session::getFormToken() . '\" data-baseurl=\"' . Uri::base(true) . '\">' . Text::_('COM_VISFORMS_VERIFY') . '</span><input type=\"text\" id=\"field' . $field->id . '_code\" name=\"' . $field->name . '_code\" class=\"visCSSinput verificationCode' . $extraClass . '\"' . $extraAttribs . ' />").insertAfter("#field' . $field->id . '");
				        ' . $this->getDefaultScript('active') . '
			        });
			    ';
                    break;
            }
            $this->field->customJs[] = $script;
        }
        if (!empty($this->field->toggle_value_from_sql)) {
            // no value reload, if we do not process SQL in Edit View but use stored values as input.
            if (!empty($this->field->noEditSqlProcess)) {
                return true;
            }
            // add record id as cid to event.data, needed if we are in an edit view
            $cid = 0;
            if ($this->form->displayState === $this->isEditTask || $this->form->displayState === $this->isRedisplayEditTask) {
                $cid = Factory::getApplication()->getInput()->getCmd('cid', 0);
            }
            $cidJs = ", cid: " . $cid;
            // Reload once, after form is loaded in order to set the proper value in the edit view
            $this->setOnloadReloadJs($cidJs, 'reloadValue');
            // set onchange reload event handler
            $this->reloadTriggerFields = isset($this->field->reload) ? $this->field->reload : array();
            if (empty($this->reloadTriggerFields)) {
                return true;
            }
            $this->removeDuplicateReloadTriggerFields();
            // foreach trigger field add a onchange handler which reloads the value for this field
            foreach ($this->reloadTriggerFields as $trigger) {
                foreach ($this->fields as $triggerField) {
                    $this->setReloadJs($triggerField, $trigger, $cidJs, 'reloadValue');
                }
            }
        }
    }

	protected function validatePostValue(): void {
		parent::validatePostValue();
		// additional validation of email verification code
		if ($this->field->attribute_value != "" && isset($this->field->validate_mailExists)) {
			$code = Factory::getApplication()->getInput()->post->get($this->field->name . '_code', '', 'STRING');
			$validation = new VerificationCodeValidation(array('value' => $code, 'verificationAddr' => $this->field->attribute_value));
			if (!$validation->validate()) {
                $this->field->isValid = false;
                // no custom php message for mail exists validation
                $message = new MailExistsMessage($this->field->label);
                $error = $message->getMessage();
				$this->setErrors($error);
			}
		}
	}

	// After an email address is entered
    // Add required validation to Verification Code Input field
    // Change Color of Verify Button
    // After Validation Code was entered
    // Revert Color fo Verify Button
	private function getDefaultScript($uiFwActiveButtonClass = '', $uiFwInactiveButtonClass = '') {
        $field = $this->field;
        $defaultScript = '
    	    jQuery("#field' . $field->id . '").on("change", function () {
                if (jQuery(this).val()) {
                    jQuery("#field' . $field->id . '_code").prop("required", true);
                    jQuery(".field' . $field->id . ' .verifyMailBtn").addClass("'.$uiFwActiveButtonClass.'");
                    jQuery(".field' . $field->id . ' .verifyMailBtn").removeClass("'.$uiFwInactiveButtonClass.'");
                }
                else {
                    jQuery("#field' . $field->id . '_code"  ).prop("required", false);
                    jQuery(".field' . $field->id . ' .verifyMailBtn").removeClass("'.$uiFwActiveButtonClass.'");
                    jQuery(".field' . $field->id . ' .verifyMailBtn").removeClass("'.$uiFwInactiveButtonClass.'");
                }
            });
            jQuery("#field' . $field->id . '_code").on("change", function () {
                if (jQuery(this).val()) {
                    jQuery(".field' . $field->id . ' .verifyMailBtn").removeClass("'.$uiFwActiveButtonClass.'");
                    jQuery(".field' . $field->id . ' .verifyMailBtn").addClass("'.$uiFwInactiveButtonClass.'");
                }
            });
    	';
        return $defaultScript;
    }
}