<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Site\Lib\Message\LocationMessage;
use Visolutions\Component\Visforms\Site\Lib\Message\RequiredMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\LatitudeValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\LongitudeValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\NotEmptyValidation;

class LocationFieldBusiness extends Business
{

	public function getFields() {
		$this->setField();

		return $this->fields;
	}

	protected function setField() {
		$this->setCustomJs();
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}

	protected function validatePostValue(): void {
		$this->updateField();
		$valid = true;
		if (!empty($this->field->attribute_value_lat) && empty($this->field->attribute_value_lng)) {
			$valid = false;
		}
		if (empty($this->field->attribute_value_lat) && !empty($this->field->attribute_value_lng)) {
			$valid = false;
		}
		if ($this->field->attribute_value_lat != "") {
		    $validation = new LatitudeValidation(array('value' => $this->field->attribute_value_lat));
			if (!$validation->validate()) {
				$valid = false;
			}
		}
		if ($this->field->attribute_value_lng != "") {
		    $validation = new LongitudeValidation(array('value' => $this->field->attribute_value_lng));
			if (!$validation->validate()) {
				$valid = false;
			}
		}
		if (!$valid) {
            $this->field->isValid = false;
            $message = new LocationMessage($this->field->label, $this->field->custom_php_error);
            $error = $message->getMessage();
            // attach error to form
            $this->setErrors($error);
		}
	}

	public function validateRequired() {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			if (isset($this->field->attribute_required)) {
				if (empty($this->field->isDisabled)) {
				    $latNotEmptyValidation = new NotEmptyValidation(array('value' => $this->field->attribute_value_lat));
				    $lngNotEmptyValidation = new NotEmptyValidation(array('value' => $this->field->attribute_value_lng));
					if (!$latNotEmptyValidation->validate()	|| !$lngNotEmptyValidation->validate()) {
						$this->field->isValid = false;
                        $message = new RequiredMessage($this->field->label, $this->field->custom_php_error);
                        $error = $message->getMessage();
						// attach error to form
						$this->setErrors($error);
					}
				}
			}
		}

		return $this->field;
	}

	protected function setCustomJs() {
		if (!empty($this->field->attribute_value_lat) && !empty($this->field->attribute_value_lng)) {
			$attPos = '{lat: ' . $this->field->attribute_value_lat . ', lng: ' . $this->field->attribute_value_lng . '}';
		} else {
			$attPos = '{}';
		}
		if (!empty($this->field->defaultMapCenter_lat) && !empty($this->field->defaultMapCenter_lng)) {
			$mapCenter = '{lat: ' . $this->field->defaultMapCenter_lat . ', lng: ' . $this->field->defaultMapCenter_lng . '}';
		} else {
			$mapCenter = '{}';
		}
		$fieldOptions = '{fieldId: ' . $this->field->id . ', displayMap : ' . (empty($this->field->displayLocationInMap) ? 0 : 1) . ', attPos : ' . $attPos . ', mapCenter : ' . $mapCenter . ', zoom : ' . (empty($this->field->zoom) ? 13 : $this->field->zoom) . '}';
		$script = '';
		$script .= 'var vfMarkers' . $this->field->id . ' = []; var vfMap' . $this->field->id . ';';
		$script .= 'jQuery(document).ready(function() {initLocation(' . $fieldOptions . ');});';
		$this->field->customJs[] = $script;
	}
}