<?php
/**
 * Visforms field email business class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Business;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Visolutions\Component\Visforms\Site\Lib\Message\PhoneMessage;
use Visolutions\Component\Visforms\Site\Lib\Validation\PhoneValidation;
use Visolutions\Component\Visforms\Site\Lib\Validation\NotEmptyValidation;
use Visolutions\Component\Visforms\Site\Lib\Message\RequiredMessage;

class TelFieldBusiness extends TextFieldBusiness {

	protected function setField() {
        $this->setCustomJs();
		$this->setIsDisabled();
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->validatePostValue();
		}
		$this->addShowWhenForForm();
	}

	 protected function validatePostValue(): void {
		parent::validatePostValue();
		// additional validation of phone number format
		if ($this->field->attribute_value != "" && isset($this->field->phonevalidation)) {
            // do not validate the value in attribute_value for disabled fields, if attribute_value and configurationDefault are exactly identical
            if (($this->field->isDisabled && $this->field->attribute_value === $this->field->configurationDefault)) {
                return;
            }
            // use purged value instead of attribute_value
            $purgeValue = $this->getValidationValue();
            $validation = new PhoneValidation(array('value' =>  $purgeValue, 'format' => $this->field->phonevalidation));
			if (!$validation->validate()) {
                $this->field->isValid = false;
                $message = new PhoneMessage($this->field->label, $this->field->custom_php_error, array('format' => $this->field->phonevalidation), (!empty($this->field->allowedCharMessage)) ? $this->field->allowedCharMessage : '');
                $error = $message->getMessage();
				$this->setErrors($error);
			}
		}
	}

	// custom implementation for field type tel
    // use purged value instead of attribute_value
    public function validateRequired() {
        if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
            // check that a value is set if field is required
            if (isset($this->field->attribute_required)) {
	            // only for fields that are not disabled
	            if (empty($this->field->isDisabled)) {
                    $purgedValue = $this->getValidationValue();
                    $validation = new NotEmptyValidation(array('value' => $purgedValue));
                    if (!$validation->validate()) {
                        $this->field->isValid = false;
                        $message = new RequiredMessage($this->field->label, $this->field->custom_php_error);
                        $error = $message->getMessage();
                        // attach error to form
                        $this->setErrors($error);
                    }
                }
            }
        }
        return $this->field;
    }

    // remove allowed _include characters from attribute_value
    // return purged value
    private function getValidationValue() {
        $purgedValue = $this->field->attribute_value;
        if (!empty($this->field->phonevalidation) && !empty($this->field->phonevalidation_include) && is_array($this->field->phonevalidation_include)) {
            foreach ($this->field->phonevalidation_include as $purge) {
                if ($purge === "BLANK") {
                    $purgedValue = str_replace(" ", "", $purgedValue);
                }
                if ($purge === "BRACKET") {
                    $purgedValue = str_replace("(", "", $purgedValue);
                    $purgedValue = str_replace(")", "", $purgedValue);
                }
                if ($purge === "POINT") {
                    $purgedValue = str_replace(".", "", $purgedValue);
                }
                if ($purge === "SLASH") {
                    $purgedValue = str_replace("/", "", $purgedValue);
                }
                if ($purge === "MINUS") {
                    if (!($this->field->phonevalidation === "NANP")) {
                        $purgedValue = str_replace("-", "", $purgedValue);
                    }
                }
                if ($purge === "PLUS") {
                    if (!($this->field->phonevalidation === "ITU-T")) {
                        $purgedValue = str_replace("+", "", $purgedValue);
                    }
                }
            }
        }
	    return $purgedValue;
    }
}