<?php
/**
 * Visforms field text class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class CalculationField extends TextField
{
	public function __construct($field, $form) {
		parent::__construct($field, $form);
		$this->postValue = $this->input->post->get($field->name, '', 'STRING');
		// no edit or query Value for calculation fields
	}

	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->setFieldDefaultValue();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setShowRequiredAsterix();
        $this->replaceLabelWithCustomText();
        $this->setNoFocus();
	}

	protected function setFieldDefaultValue(): void {
		// if we have a POST Value, we set the dataSource and empty attribute_value
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			$this->field->attribute_value = "";
			$this->field->dataSource = 'post';
		}
	}

	protected function setDbValue(): void {
		// value is calculated. This is business logic performed by the business files
	}

	protected function setRedirectParam(): void {
		// nothing to do;
	}
}