<?php
/**
 * Visforms field trait
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

trait FieldAwareTrait
{
    private $field;

    public function setField($field, $form) {
        if ((isset($field->typefield))) {
            $class = '\Visolutions\Component\Visforms\Site\Lib\Field\\'. ucfirst($field->typefield) . 'Field';
            $this->field = new $class($field, $form);
            return;
        }
        throw new \InvalidArgumentException('Cannot create field without type');
    }

    public function getField() {
        if ($this->field) {
            return $this->field;
        }
        throw new \UnexpectedValueException('Field not set in ' . __CLASS__);
    }
}