<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class SelectsqlField extends SelectField
{
	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
		$this->prepareFieldForNoEditSqlProcess();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
		$this->setIsConditional();
		$this->setIsDisplayChanger();
		$this->getOptions();
		$this->disableUsedOptsOnUniqueValues();
		$this->removeInvalidQueryValues();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setRedirectParam();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->mendInvalidUncheckedValue();
		$this->setShowRequiredAsterix();
        $this->hasSearchableSelect();
        $this->replaceLabelWithCustomText();
	}

	protected function getOptions() {
		// no options for select given
        // support 'no_sql_process_in_edit_view'
        // $this->isEditOrSaveEditTask: Display Edit View Or Save edited data
        // use values, stored in database, and create the options from the stored values
        if (!empty($this->field->noEditSqlProcess)) {
            $cid = $this->input->get('cid', 0, 'int');
            $dbValue = HTMLHelper::_('visformsselect.getStoredUserInput', $this->field->id, $this->form->id, $cid);
            $returnOpts = array();
            if (!empty($dbValue)) {
                $uniqueDbValues = array();
                // extract single option values from multiselect
                $singleValues = HTMLHelper::_('visformsselect.explodeMsDbValue', $dbValue);
                // create an array with one element for each unique single dbValue;
                foreach ($singleValues as $singleValue) {
                    $singleValue = (string) $singleValue;
                    $uniqueDbValues[$singleValue] = $singleValue;
                }
                foreach ($uniqueDbValues as $uniqueDbValue) {
                    // set selected false here. Selection is set later in setFieldDefaultValue()
                    $returnOpts[] = array( 'value' => $uniqueDbValue, 'label' => $uniqueDbValue, 'selected' => false);
                }
            }
            $this->field->opts = $returnOpts;
        }
        else {
            $sql = $this->field->sql;
            $this->field->opts = HTMLHelper::_('visformsselect.getOptionsFromSQL', $sql, (isset($this->form->context) ? $this->form->context : ''));
        }
	}

    protected function setEditOnlyFieldDbValue(): void {
	    // no db value, if selectsql rendered as data list
	    if (!empty($this->field->render_as_datalist)) {
	        return;
        }
	    // if we have only one option and this should be preselected, use the value of this option
	    if (!empty($this->field->preSelectSolitaryOption) && count($this->field->configurationDefault) === 1) {
            $this->field->editOnlyFieldDbValue = $this->field->configurationDefault[0]['value'];
        }
	    else {
            // there can only be one default selected option!
            foreach ($this->field->configurationDefault as $opt) {
                if ($opt['selected']) {
                    $this->field->editOnlyFieldDbValue = $opt['value'];
                    break;
                }
            }
        }
    }

	// custom override
    // take 'render_as_datalist' into account
	protected function prepareFieldForNoEditSqlProcess(): void {
	    // new option which might not be set in older fields
        // Default is 'process' with a value of 1
        // so only if option is set and has the value 0 no process of sql in edit view
        if ($this->isEditOrSaveEditTask && ((isset($this->field->sql_process_in_edit_view) && empty($this->field->sql_process_in_edit_view)) && empty($this->field->render_as_datalist))) {
            $this->field->noEditSqlProcess = true;
        }
    }
}