<?php
/**
 * Visforms field submit class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class SubmitField extends Field
{
    protected function setField(): void {
        $this->cleanFieldProperties();
        $this->extractDefaultValueParams();
	    $this->extractGridSizesParams();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
        $this->setIndividualProperties();
        $this->setFieldDefaultValue();
        $this->setCustomJs();
    }
    

    protected function setFieldDefaultValue(): void {
        // Nothing to do
    }
    
    protected function setIndividualProperties() {
        $this->field->isButton = true;
    }
    
    protected function setDbValue(): void {
        // Nothing to do
    }

    protected function setRedirectParam(): void {
        // Nothing to do
    }

    protected function cleanFieldProperties() {
        // Nothing to do
    }

    protected function setConfigurationDefault(): void {
        // Nothing to do
    }

    protected function setEditOnlyFieldDbValue(): void {
        // Nothing to do
    }
}