<?php
/**
 * Visforms field textarea class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Field;

// no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\User\User;
use Joomla\CMS\User\UserHelper;
use Joomla\CMS\Component\ComponentHelper;
use Visolutions\Component\Visforms\Site\Model\VisformsModel as VisformsModelSite;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\HTML\HTMLHelper;
use Visolutions\Component\Visforms\Site\Event\Visforms\VisfieldBeforeCreateEvent;

class TextareaField extends Field
{
	// no setting of $this->postValue or $this->editValue in a constructor for this field type. Values are set in $this->getDefaultInputs()
	// no queryValue allowed for textareas!

	protected function setField(): void {
		// preprocessing field
		$this->extractDefaultValueParams();
		$this->extractGridSizesParams();
		$this->extractRestrictions();
		$this->mendBooleanAttribs();
        $this->unsetDeselectedEditViewValidations();
        $this->setCustomPhpErrorMsg();
        PluginHelper::importPlugin('visforms');
        $dispatcher = Factory::getApplication()->getDispatcher();
        $event = new VisfieldBeforeCreateEvent('onVisfieldBeforeCreate', [
            'subject' => $this->field,
            'context' => 'com_visforms.field',
            'form' => $this->form
        ]);
        $dispatcher->dispatch('onVisfieldBeforeCreate', $event);
        $this->setIndividualProperties();
		$this->getDefaultInputs();
		$this->setIsConditional();
        $this->fillWith();
		$this->setEditValue();
		$this->setConfigurationDefault();
		$this->setEditOnlyFieldDbValue();
		$this->setFieldDefaultValue();
		$this->setDbValue();
		$this->setCustomJs();
		$this->setFieldsetCounter();
		$this->setShowRequiredAsterix();
		$this->replaceLabelWithCustomText();
	}

	protected function setFieldDefaultValue(): void {
		$field = $this->field;
		if ($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) {
			if ((isset($this->field->editValue))) {
				$this->field->initvalue = $this->field->editValue;
			}
			$this->field->dataSource = 'db';
			return;
		}
		// if we have a POST Value, we use this
		if ((count($_POST) > 0) && isset($_POST['postid']) && ($_POST['postid'] == $this->form->id)) {
			if (isset($_POST[$field->name])) {
				$this->field->initvalue = $this->postValue;
			} 
			else {
				$this->field->initvalue = $this->field->configurationDefault;
			}
			$this->field->dataSource = 'post';
			return;
		}
		// No query (GET) values for textarea
		// Nothing to do
	}

	protected function setIndividualProperties() {
		$field = $this->field;
		// we have an HTMLEditor and have to check that it is not empty
		if (isset($field->attribute_required) && isset($field->HTMLEditor) && $field->HTMLEditor == '1' && (!(isset($field->attribute_readonly)) || $field->attribute_readonly != "readonly")) {
			$this->field->textareaRequired = true;
		}
		// We have an HTMLEditor
		if (isset($field->HTMLEditor) && $field->HTMLEditor == '1' && (!(isset($field->attribute_readonly)) || ($field->attribute_readonly != "readonly"))) {
			$this->field->hasHTMLEditor = true;
		}
	}

	private function getDefaultInputs() {
		$field = $this->field;
		if (isset($field->hasHTMLEditor) && $field->hasHTMLEditor == true) {
			$this->postValue = ComponentHelper::filterText($this->input->post->get($field->name, '', 'RAW'));
		} else {
			$this->postValue = $this->input->post->get($field->name, '', 'STRING');
		}
	}

	protected function setDbValue(): void {
		if (isset($this->field->dataSource) && $this->field->dataSource == 'post') {
			$this->field->dbValue = $this->postValue;
		}
	}

	protected function setEditOnlyFieldDbValue(): void {
		$this->field->editOnlyFieldDbValue = $this->field->configurationDefault;
	}

	protected function setRedirectParam(): void {
		// nothing to do
	}

	protected function setConfigurationDefault(): void {
		$this->field->configurationDefault = $this->field->initvalue;
		if (!$this->isEditOrSaveEditTask) {
			$urlparams = Factory::getApplication()->getUserState('com_visforms.urlparams.' . $this->form->context, null);
			if (!empty($urlparams) && (is_array($urlparams)) && (isset($urlparams[$this->field->name]))) {
				$queryValue = $urlparams[$this->field->name];
			}
			// if form was originally called with valid url params, reset to this url params
			$this->field->configurationDefault = (isset($this->field->allowurlparam) && ($this->field->allowurlparam == true) && isset($queryValue)) ? $queryValue : $this->field->initvalue;
		}
	}

	protected function setEditValue(): void {
		if ($this->isEditOrSaveEditTask) {
			$this->field->editValue = "";
			$data = $this->form->data;
			$dataFieldName = $this->getParameterFieldNameForEditValue();
			if (isset($data->$dataFieldName)) {
				$filter = InputFilter::getInstance();
				if (isset($this->field->hasHTMLEditor) && $this->field->hasHTMLEditor == true) {
					$this->field->editValue = ComponentHelper::filterText($data->$dataFieldName);
				} else {
					$this->field->editValue = $filter->clean($data->$dataFieldName, 'STRING');
				}
			}
		}
	}

    // override a default value set in attribute_value if fillwith is not set to '0'
    protected function fillWith(): void {
        $field = $this->field;
        // no custom default value selection.
        // don't change 'attribute_value'
        if ((!isset($field->fillwith) || $field->fillwith === "0")) {
            return;
        }
        // process fillwith user data
        // if we edit stored user inputs we want to use the user profile of the user who submitted the form as default fill with values
        if (($this->form->displayState === VisformsModelSite::$displayStateIsNewEditData) || ($this->form->displayState === VisformsModelSite::$displayStateIsRedisplayEditData)) {
            $data = $this->form->data;
            $userId = $data->created_by;
            if (!empty($userId)) {
                $user = new User($userId);
            }
        }
        // use user profile of logged-in user
        else {
            $user = Factory::getApplication()->getIdentity();
            $userId = $user->id;
        }
        if ($userId != 0) {
            preg_match('/^CF(\d+)$/', $field->fillwith, $matches);
            if ($matches && !empty($matches[1])) {
                $customfieldid = $matches[1];
                $value = HTMLHelper::_('visforms.getCustomUserFieldValue', $customfieldid, $user);
                // in error case, value === false
                if ($value !== false) {
                    $this->field->initvalue = $this->convertLineBreaks($value);
                    return;
                }
            }
            $userProfile = UserHelper::getProfile($userId);
            if ((!(empty($userProfile->profile))) && (is_array($userProfile->profile))) {
                if (!(empty($userProfile->profile[$field->fillwith]))) {
                    $this->field->initvalue = $this->convertLineBreaks($userProfile->profile[$field->fillwith]);
                    return;
                }
            }
        }
        // no value found, set attribute_value to ''
        $this->field->initvalue = '';
    }

    private function convertLineBreaks($text) {
        if (isset($this->field->hasHTMLEditor) && $this->field->hasHTMLEditor == true) {
            return HTMLHelper::_('visforms.replaceLinebreaks', $text, "<br />");
        }
        else {
            return $text;
        }
    }
}