<?php
/**
 * Visforms HTMLLayout class 
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Html\Layout;

// no direct access
use Visolutions\Component\Visforms\Site\Lib\Html\Field\BaseHtmlField;

defined('_JEXEC') or die('Restricted access');

trait HtmlLayoutAwareTrait
{
    private $htmlLayout;

    public function setHtmlLayout($type, BaseHtmlField $fieldHtml, $subType = 'horizontal') {
        if (empty($type)) {
            $type = 'visforms';
        }
        $className = $this->getLayoutClassName($type);
        $this->htmlLayout = new $className($type, $fieldHtml, $subType);
    }

    public function getHtmlLayout() {
        if ($this->htmlLayout) {
            return $this->htmlLayout;
        }
        throw new \UnexpectedValueException('Form Html layout not set in ' . __CLASS__);
    }

    private function getLayoutClassName($name) {
        switch ($name) {
            case 'bt5' :
                $className = 'Bt5Layout';
                break;
            case 'editbt5' :
                $className = 'Bt5EditLayout';
                break;
            case 'uikit3' :
                $className = 'Uikit3Layout';
                break;
            case 'edituikit3' :
                $className = 'Uikit3EditLayout';
                break;
            case 'edit' :
                $className = 'NoneEditLayout';
                break;
            default :
                $className = 'NoneLayout';
        }
        return '\Visolutions\Component\Visforms\Site\Lib\Html\Layout\\'.$className;
    }
}