<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2019 vi-solutions
 */
namespace  Visolutions\Component\Visforms\Site\Lib\Layout\Helper;
// no direct access
defined('_JEXEC') or die('Restricted access');
use Visolutions\Component\Visforms\Administrator\Helper\AefHelper;

class Bt5FormLayoutStateHelper implements FormLayoutStateHelper {

	protected $breakPoints = array('Sm', 'Md', 'Lg', 'Xl', 'Xxl');
	protected $form;

	public function fixInvalidLayoutSelection($formLayout) {
        $hasIndividualLayout = AefHelper::checkAEF();
        $form = $formLayout->getForm();
        if (empty($hasIndividualLayout)) {
            if (isset($form->displaysublayout) && $form->displaysublayout == 'individual') {
                // reset to default
                $form->displaysublayout = 'horizontal';
                $formLayout->updateForm($form);
            }
        }
        return $form;
	}

	public function setLayoutOptions($formLayout) {
		$this->form = $formLayout->getForm();
		if (empty($this->form->captchaLabelBootstrapWidth) || ($this->form->displaysublayout != 'individual')) {
			if ($this->form->displaysublayout == 'stacked' || $this->form->displaysublayout == 'individual') {
				$this->form->captchaLabelBootstrapWidth = "12";
			}
			else {
				$this->form->captchaLabelBootstrapWidth = "3";
			}
		}
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'captchaLabelBootstrapWidth' . $breakPoint;
			if (empty($this->form->$name) || ($this->form->displaysublayout != 'individual')) {
				if ($this->form->displaysublayout == 'stacked' || $this->form->displaysublayout == 'individual') {
					$this->form->$name = "12";
				}
				else {
					$this->form->$name = "3";
				}
			}
		}
		$this->getCaptchaInputBtClasses();
		$this->getIndentedBtClasses();
		$this->getCaptchaLabelClasses();
		$this->setButtonClass();
		$formLayout->updateForm($this->form);
		return $this->form;
	}

	protected function setButtonClass() {
		if (empty($this->form->summarybtncssclass)) {
			$this->form->summarybtncssclass = 'btn-info';
		}
		if (empty($this->form->correctbtncssclass)) {
			$this->form->correctbtncssclass = 'btn-info';
		}
		if (empty($this->form->backbtncssclass)) {
			$this->form->backbtncssclass = 'btn-info';
		}
		if (empty($this->form->savebtncssclass)) {
			$this->form->savebtncssclass = 'btn-primary';
		}
		if (empty($this->form->cancelbtncssclass)) {
			$this->form->cancelbtncssclass = 'btn-secondary';
		}
	}

	// Captcha Layout Settings

	// Captcha, Captcha control group and label width are form options
    // get width for Captcha input depending on label width settings
	protected function getCaptchaInputBtClasses() {
		$classes = ($this->form->captchaLabelBootstrapWidth != "12") ? ' col-' . (12 - $this->form->captchaLabelBootstrapWidth) : ' col-12';
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'captchaLabelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$classes .= ($this->form->$name != "12") ? ' col-' . $lcBreakPoint . '-' . (12 - $this->form->$name) : ' col-' . $lcBreakPoint . '-12';
		}
		$this->form->captchaInputBtClasses = $classes;
	}

	// use for indentation of Captcha error div
    // Text must be offset according to label width
	protected function getIndentedBtClasses() {
		$indentedBtClasses = ($this->form->captchaLabelBootstrapWidth != "12") ? 'offset-' . $this->form->captchaLabelBootstrapWidth . ' col-' . (12 - $this->form->captchaLabelBootstrapWidth) : 'col-12';
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'captchaLabelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$indentedBtClasses .= ($this->form->$name != "12") ? ' offset-' . $lcBreakPoint . '-' . $this->form->$name . ' col-' . $lcBreakPoint . '-' . (12 - $this->form->$name) : '  offset-' . $lcBreakPoint . '-0 col-' . $lcBreakPoint . '-12';
		}
		$this->form->indentedBtClasses =  $indentedBtClasses;
	}

	protected function getCaptchaLabelClasses() {
		$labelClasses = 'col-' . $this->form->captchaLabelBootstrapWidth;
		foreach ($this->breakPoints as $breakPoint) {
			$name = 'captchaLabelBootstrapWidth' . $breakPoint;
			$lcBreakPoint = lcfirst($breakPoint);
			$labelClasses .= ' col-' . $lcBreakPoint . '-' . $this->form->$name;
		}
		$labelClasses .= ' asterix-ancor';
		$this->form->captchaLabelClasses =  $labelClasses;
	}
}