<?php
/**
 * Visforms message date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace  Visolutions\Component\Visforms\Site\Lib\Message;

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;

class PhoneMessage extends Message
{
    protected $text = 'COM_VISFORMS_PHONE_NUMBER_FORMAT_INCORRECT';

	protected function setMessage(): string {
        // if we have a custom php error message, return ''
        // the custom php error message is added in the business/field class only once to each invalid field
        if (!empty($this->customText)) {
            return '';
        }
        else {
            $format = (isset($this->args['format'])) ? $this->args['format'] : '';
            $baseMessage = Text::sprintf($this->text, $this->name, $format, Text::_("COM_VISFORMS_PHONE_NUMBER_FORMAT_".$format));
            if (!empty($this->allowedCharMessage)) {
                return $baseMessage . ' ' . $this->allowedCharMessage;
            }
            return $baseMessage;
        }
	}
}