<?php
/**
 * Visforms validate equalTo class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class EqualToValidation extends Validation
{
	protected $value;
	protected $cvalue;

	public function __construct($args) {
	    parent::__construct($args);
		// we expect an item with key 'value' and an item with key 'cvalue' in $args
		$this->value = $this->args['value'] ?? '';
		$this->cvalue = $this->args['cvalue'] ?? '';
	}

    public function validate(): bool {
	    if (is_numeric($this->value) && is_numeric($this->cvalue)) {
		    if ($this->value == $this->cvalue) {
			    return true;
		    }
		    else {
			    return false;
		    }
	    }
		if ($this->value === $this->cvalue) {
			return true;
		} 
		else {
			return false;
		}
	}
}