<?php
/**
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2017 vi-solutions
 */
namespace Visolutions\Component\Visforms\Site\Lib\Validation;

// no direct access
defined('_JEXEC') or die('Restricted access');

class LongitudeValidation extends Validation
{
	protected $value;
	protected $regex;

	public function __construct($args) {
	    parent::__construct($args);
		// we expect an item with key 'value' and an item with key 'regex' in $args
		$this->value = $this->args['value'] ?? "";
		$this->regex = "/^[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/";
	}

    public function validate(): bool {
		if (!(preg_match($this->regex, $this->value))) {
			return false;
		} 
		else {
			return true;
		}
	}
}