<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_visforms
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
/** @var array $displayData */

$data = $displayData;

// Custom Adaption wich allows to display more then 1 selector listbox in the left side of the filter

// Receive overridable options
$data['options'] = !empty($data['options']) ? $data['options'] : [];

$noResultsText     = '';
$hideActiveFilters = false;
$showFilterButton  = false;
$showSelector      = false;
// we just take on layout file, out of Joomla.
// all other searchtool files are still default
// keep Joomla parameter for compatibility
$selectorFieldName = $data['options']['selectorFieldName'] ?? 'client_id';
// allow multiple selector field names
$selectorFieldNames = array();
if (isset( $data['options']['selectorFieldName'])) {
    if (!is_array( $data['options']['selectorFieldName'])) {
        $selectorFieldNames = array($data['options']['selectorFieldName']);
    }
    else {
            $selectorFieldNames = $data['options']['selectorFieldName'];
        }
}

// if a filter form exists.
if (isset($data['view']->filterForm) && !empty($data['view']->filterForm)) {
    // unset alle selector fields form active filter
    foreach ($selectorFieldNames as $selectorFieldName) {
        if ($data['view']->filterForm->getField($selectorFieldName)) {
            // Unset the selector field from active filters group.
            unset($data['view']->activeFilters[$selectorFieldName]);
        }
    }

    // checks if the filters button should exist.
    $filters = $data['view']->filterForm->getGroup('filter');
    $showFilterButton = isset($filters['filter_search']) && count($filters) === 1 ? false : true;

    // checks if it should show the be hidden.
    $hideActiveFilters = empty($data['view']->activeFilters);

    // Check if the no results message should appear.
    if (isset($data['view']->total) && (int) $data['view']->total === 0) {
        $noResults = $data['view']->filterForm->getFieldAttribute('search', 'noresults', '', 'filter');
        if (!empty($noResults)) {
            $noResultsText = Text::_($noResults);
        }
    }
}

// set some basic options.
$customOptions = [
    'filtersHidden'       => isset($data['options']['filtersHidden']) && $data['options']['filtersHidden'] ? $data['options']['filtersHidden'] : $hideActiveFilters,
    'filterButton'        => isset($data['options']['filterButton']) && $data['options']['filterButton'] ? $data['options']['filterButton'] : $showFilterButton,
    'defaultLimit'        => $data['options']['defaultLimit'] ?? Factory::getApplication()->get('list_limit', 20),
    'searchFieldSelector' => '#filter_search',
    'selectorFieldName'   => $selectorFieldName,
    'showSelector'        => $showSelector,
    'orderFieldSelector'  => '#list_fullordering',
    'showNoResults'       => !empty($noResultsText),
    'noResultsText'       => !empty($noResultsText) ? $noResultsText : '',
    'formSelector'        => !empty($data['options']['formSelector']) ? $data['options']['formSelector'] : '#adminForm',
];

// merge custom options in the options array.
$data['options'] = array_merge($customOptions, $data['options']);

// add class to hide the active filters if needed.
$filtersActiveClass = $hideActiveFilters ? '' : ' js-stools-container-filters-visible';

// load search tools
HTMLHelper::_('searchtools.form', $data['options']['formSelector'], $data['options']);
?>
<div class="js-stools" role="search"><?php
    // loop through all selector fields
    // check if the are to be displayed
    // if yes: set selectorFieldname and showSelector value for this field in $data['options']
    foreach ($selectorFieldNames as $selectorFieldName) {
        if ($selectorField = $data['view']->filterForm->getField($selectorFieldName)) {
            $showSelector = $selectorField->getAttribute('filtermode', '') === 'selector' ? true : $showSelector;
            $data['options']['selectorFieldName'] = $selectorFieldName;

            // Checks if a selector should be shown in the current layout.
            if (isset($data['view']->layout)) {
                $showSelector = $selectorField->getAttribute('layout', 'default') != $data['view']->layout ? false : $showSelector;
            }
            // set value of showSelector in data and render the selector field if showSelector is true
            if ($data['options']['showSelector'] = $showSelector) { ?>
            <div class="js-stools-container-selector">
                <?php echo LayoutHelper::render('joomla.searchtools.default.selector', $data); ?>
            </div>
        <?php }
        }
    }?>
    <div class="js-stools-container-bar ms-auto">
        <div class="btn-toolbar">
            <?php echo $this->sublayout('bar', $data); ?>
            <?php echo $this->sublayout('list', $data); ?>
        </div>
    </div>
    <!-- Filters div -->
    <div class="js-stools-container-filters clearfix<?php echo $filtersActiveClass; ?>">
        <?php if ($data['options']['filterButton']) : ?>
            <?php echo $this->sublayout('filters', $data); ?>
        <?php endif; ?>
    </div>
</div>
<?php if ($data['options']['showNoResults']) : ?>
    <?php echo $this->sublayout('noitems', $data); ?>
<?php endif; ?>
